/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.xml;

import com.helger.commons.filter.ISerializableFilter;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.w3c.dom.Element;

@NotThreadSafe
public final class FilterElementWithoutNamespace
implements ISerializableFilter<Element> {
    private static final FilterElementWithoutNamespace s_aInstance = new FilterElementWithoutNamespace();

    private FilterElementWithoutNamespace() {
    }

    @Nonnull
    public static FilterElementWithoutNamespace getInstance() {
        return s_aInstance;
    }

    @Override
    public boolean matchesFilter(@Nullable Element element) {
        return element != null && StringHelper.hasNoText(element.getNamespaceURI());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return object != null && this.getClass().equals(object.getClass());
    }

    public int hashCode() {
        return new HashCodeGenerator(this).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).toString();
    }
}

