/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.xml.sax;

import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.error.IErrorLevel;
import com.helger.commons.error.IHasResourceErrorGroup;
import com.helger.commons.error.IResourceErrorGroup;
import com.helger.commons.error.ResourceErrorGroup;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.xml.sax.AbstractSAXErrorHandler;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

@ThreadSafe
public class CollectingSAXErrorHandler
extends AbstractSAXErrorHandler
implements IHasResourceErrorGroup {
    protected final ReadWriteLock m_aRWLock = new ReentrantReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ResourceErrorGroup m_aErrors = new ResourceErrorGroup();

    public CollectingSAXErrorHandler() {
    }

    public CollectingSAXErrorHandler(@Nullable ErrorHandler errorHandler) {
        super(errorHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void internalLog(@Nonnull IErrorLevel iErrorLevel, SAXParseException sAXParseException) {
        this.m_aRWLock.writeLock().lock();
        try {
            this.m_aErrors.addResourceError(CollectingSAXErrorHandler.getSaxParseError(iErrorLevel, sAXParseException));
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    @ReturnsMutableCopy
    public IResourceErrorGroup getResourceErrors() {
        this.m_aRWLock.readLock().lock();
        try {
            ResourceErrorGroup resourceErrorGroup = this.m_aErrors.getClone();
            return resourceErrorGroup;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAtLeastOneError() {
        this.m_aRWLock.readLock().lock();
        try {
            boolean bl = this.m_aErrors.containsAtLeastOneError();
            return bl;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public EChange clearResourceErrors() {
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = this.m_aErrors.clear();
            return eChange;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("errors", this.m_aErrors).toString();
    }
}

