/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.xml.transform;

import com.helger.commons.error.EErrorLevel;
import com.helger.commons.error.IErrorLevel;
import com.helger.commons.error.IResourceError;
import com.helger.commons.error.IResourceLocation;
import com.helger.commons.error.ResourceError;
import com.helger.commons.error.ResourceLocation;
import com.helger.commons.name.IHasDisplayText;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.xml.transform.EXMLTransformTexts;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;

public abstract class AbstractTransformErrorListener
implements ErrorListener {
    private final ErrorListener m_aWrappedErrorListener;

    public AbstractTransformErrorListener() {
        this(null);
    }

    public AbstractTransformErrorListener(@Nullable ErrorListener errorListener) {
        this.m_aWrappedErrorListener = errorListener;
    }

    @Nullable
    public ErrorListener getWrappedErrorListener() {
        return this.m_aWrappedErrorListener;
    }

    @Nonnull
    private static IResourceError _buildError(@Nonnull TransformerException transformerException, @Nonnull IErrorLevel iErrorLevel, @Nonnull IHasDisplayText iHasDisplayText) {
        SourceLocator sourceLocator = transformerException.getLocator();
        ResourceLocation resourceLocation = sourceLocator != null ? new ResourceLocation(StringHelper.getConcatenatedOnDemand(sourceLocator.getPublicId(), "/", sourceLocator.getSystemId()), sourceLocator.getLineNumber(), sourceLocator.getColumnNumber()) : new ResourceLocation(transformerException.getLocationAsString());
        return new ResourceError((IResourceLocation)resourceLocation, iErrorLevel, iHasDisplayText, (Throwable)transformerException);
    }

    protected abstract void internalLog(@Nonnull IResourceError var1);

    @Override
    public final void warning(@Nonnull TransformerException transformerException) throws TransformerException {
        this.internalLog(AbstractTransformErrorListener._buildError(transformerException, EErrorLevel.WARN, EXMLTransformTexts.TRANSFORMATION_WARNING));
        ErrorListener errorListener = this.getWrappedErrorListener();
        if (errorListener != null) {
            errorListener.warning(transformerException);
        }
    }

    @Override
    public final void error(@Nonnull TransformerException transformerException) throws TransformerException {
        this.internalLog(AbstractTransformErrorListener._buildError(transformerException, EErrorLevel.ERROR, EXMLTransformTexts.TRANSFORMATION_ERROR));
        ErrorListener errorListener = this.getWrappedErrorListener();
        if (errorListener != null) {
            errorListener.error(transformerException);
        }
    }

    @Override
    public final void fatalError(@Nonnull TransformerException transformerException) throws TransformerException {
        this.internalLog(AbstractTransformErrorListener._buildError(transformerException, EErrorLevel.FATAL_ERROR, EXMLTransformTexts.TRANSFORMATION_FATAL_ERROR));
        ErrorListener errorListener = this.getWrappedErrorListener();
        if (errorListener != null) {
            errorListener.fatalError(transformerException);
        }
    }

    public String toString() {
        return new ToStringGenerator(this).appendIfNotNull("wrappedErrorListener", this.m_aWrappedErrorListener).toString();
    }
}

