/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.csv;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.iterate.ArrayIterator;
import com.helger.commons.io.stream.StreamHelper;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CSVWriter
implements Closeable,
Flushable {
    public static final char NO_QUOTE_CHARACTER = '\u0000';
    public static final char NO_ESCAPE_CHARACTER = '\u0000';
    public static final String DEFAULT_LINE_END = "\n";
    public static final boolean DEFAULT_QUOTE_ALL = true;
    private final Writer m_aRawWriter;
    private final PrintWriter m_aPW;
    private char m_cSeparatorChar = (char)44;
    private char m_cQuoteChar = (char)34;
    private char m_cEscapeChar = (char)92;
    private String m_sLineEnd = "\n";

    public CSVWriter(@Nonnull Writer writer) {
        ValueEnforcer.notNull(writer, "Writer");
        this.m_aRawWriter = writer;
        this.m_aPW = new PrintWriter(writer);
    }

    @Deprecated
    public char getSeparator() {
        return this.getSeparatorChar();
    }

    public char getSeparatorChar() {
        return this.m_cSeparatorChar;
    }

    @Deprecated
    @Nonnull
    public CSVWriter setSeparator(char c) {
        return this.setSeparatorChar(c);
    }

    @Nonnull
    public CSVWriter setSeparatorChar(char c) {
        if (c == '\u0000') {
            throw new UnsupportedOperationException("The separator character must be defined!");
        }
        this.m_cSeparatorChar = c;
        return this;
    }

    @Deprecated
    public char getQuotechar() {
        return this.getQuoteChar();
    }

    public char getQuoteChar() {
        return this.m_cQuoteChar;
    }

    @Nonnull
    public CSVWriter setQuoteChar(char c) {
        this.m_cQuoteChar = c;
        return this;
    }

    @Deprecated
    public char getEscape() {
        return this.getEscapeChar();
    }

    public char getEscapeChar() {
        return this.m_cEscapeChar;
    }

    @Nonnull
    public CSVWriter setEscapeChar(char c) {
        this.m_cEscapeChar = c;
        return this;
    }

    @Nonnull
    @Nonempty
    public String getLineEnd() {
        return this.m_sLineEnd;
    }

    @Nonnull
    public CSVWriter setLineEnd(@Nonnull @Nonempty String string) {
        ValueEnforcer.notNull(string, "LineEnd");
        this.m_sLineEnd = string;
        return this;
    }

    public void writeAll(@Nonnull List<List<String>> list, boolean bl) {
        for (List<String> list2 : list) {
            this.writeNext(list2, bl);
        }
    }

    public void writeAll(@Nonnull List<List<String>> list) {
        this.writeAll(list, true);
    }

    public void writeNext(@Nullable Iterator<String> iterator, boolean bl) {
        if (iterator != null) {
            StringBuilder stringBuilder = new StringBuilder(128);
            boolean bl2 = this.m_cQuoteChar != '\u0000';
            boolean bl3 = true;
            while (iterator.hasNext()) {
                boolean bl4;
                String string;
                if (bl3) {
                    bl3 = false;
                } else {
                    stringBuilder.append(this.m_cSeparatorChar);
                }
                if ((string = iterator.next()) == null) continue;
                boolean bl5 = this.stringContainsSpecialCharacters(string);
                boolean bl6 = bl4 = bl2 && (bl || bl5);
                if (bl4) {
                    stringBuilder.append(this.m_cQuoteChar);
                }
                if (bl5) {
                    stringBuilder.append((CharSequence)this.getEscapedText(string));
                } else {
                    stringBuilder.append(string);
                }
                if (!bl4) continue;
                stringBuilder.append(this.m_cQuoteChar);
            }
            stringBuilder.append(this.m_sLineEnd);
            this.m_aPW.write(stringBuilder.toString());
        }
    }

    public void writeNext(@Nullable Iterable<String> iterable, boolean bl) {
        if (iterable != null) {
            this.writeNext(iterable.iterator(), bl);
        }
    }

    public void writeNext(@Nullable Iterable<String> iterable) {
        this.writeNext(iterable, true);
    }

    public void writeNext(@Nullable String[] stringArray, boolean bl) {
        if (stringArray != null) {
            this.writeNext(ArrayIterator.create(stringArray), bl);
        }
    }

    public void writeNext(String ... stringArray) {
        this.writeNext(stringArray, true);
    }

    public void writeNext(@Nullable String[] stringArray, @Nonnegative int n, @Nonnegative int n2, boolean bl) {
        if (stringArray != null) {
            this.writeNext(ArrayIterator.createOfsLen(stringArray, n, n2), bl);
        }
    }

    public void writeNext(@Nullable String[] stringArray, @Nonnegative int n, @Nonnegative int n2) {
        this.writeNext(stringArray, n, n2, true);
    }

    protected boolean stringContainsSpecialCharacters(@Nonnull String string) {
        return string.indexOf(this.m_cQuoteChar) != -1 || string.indexOf(this.m_cEscapeChar) != -1 || string.indexOf(this.m_cSeparatorChar) != -1 || string.indexOf(13) != -1 || string.indexOf(10) != -1;
    }

    @Nonnull
    protected StringBuilder getEscapedText(@Nonnull String string) {
        if (this.m_cEscapeChar == '\u0000') {
            return new StringBuilder(string);
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
        for (char c : string.toCharArray()) {
            if (c == this.m_cQuoteChar || c == this.m_cEscapeChar) {
                stringBuilder.append(this.m_cEscapeChar);
            }
            stringBuilder.append(c);
        }
        return stringBuilder;
    }

    @Override
    public void flush() throws IOException {
        this.m_aPW.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.m_aPW.close();
        this.m_aRawWriter.close();
    }

    public boolean checkError() {
        return this.m_aPW.checkError();
    }

    public void flushQuietly() {
        StreamHelper.flush(this);
    }
}

