/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.filter;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.filter.EFilterMatchingStrategy;
import com.helger.commons.filter.IFilter;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class AbstractFilter<DATATYPE>
implements IFilter<DATATYPE> {
    private EFilterMatchingStrategy m_eMatchingStrategy = EFilterMatchingStrategy.MATCH_ANY;
    private final IFilter<? super DATATYPE> m_aNestedFilter;

    public AbstractFilter(@Nullable IFilter<? super DATATYPE> iFilter) {
        this.m_aNestedFilter = iFilter;
    }

    @Nonnull
    public final EFilterMatchingStrategy getMatchingStrategy() {
        return this.m_eMatchingStrategy;
    }

    @Nonnull
    public final AbstractFilter<DATATYPE> setMatchingStrategy(@Nonnull EFilterMatchingStrategy eFilterMatchingStrategy) {
        this.m_eMatchingStrategy = ValueEnforcer.notNull(eFilterMatchingStrategy, "MatchingStrategy");
        return this;
    }

    @Nullable
    public final IFilter<? super DATATYPE> getNestedFilter() {
        return this.m_aNestedFilter;
    }

    public abstract boolean matchesThisFilter(DATATYPE var1);

    @Override
    public final boolean matchesFilter(DATATYPE DATATYPE) {
        boolean bl = this.m_eMatchingStrategy.equals((Object)EFilterMatchingStrategy.MATCH_ANY);
        boolean bl2 = !bl;
        boolean bl3 = this.matchesThisFilter(DATATYPE);
        if (bl3 && bl) {
            return true;
        }
        if (!bl3 && bl2) {
            return false;
        }
        if (this.m_aNestedFilter == null) {
            return bl3;
        }
        boolean bl4 = this.m_aNestedFilter.matchesFilter(DATATYPE);
        return bl4;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AbstractFilter abstractFilter = (AbstractFilter)object;
        return EqualsHelper.equals(this.m_aNestedFilter, abstractFilter.m_aNestedFilter);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aNestedFilter).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).appendIfNotNull("nestedFilter", this.m_aNestedFilter).toString();
    }
}

