/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.resource;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.resource.URLResource;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.url.URLHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ClassPathResource
implements IReadableResource {
    public static final String CLASSPATH_PREFIX_LONG = "classpath:";
    public static final String CLASSPATH_PREFIX_SHORT = "cp:";
    private String m_sPath;
    private final WeakReference<ClassLoader> m_aClassLoader;
    private boolean m_bURLResolved = false;
    private URL m_aURL;

    public ClassPathResource(@Nonnull URL uRL) {
        this(uRL, null);
    }

    public ClassPathResource(@Nonnull URL uRL, @Nullable ClassLoader classLoader) {
        this(uRL.toExternalForm(), classLoader);
    }

    public ClassPathResource(@Nonnull @Nonempty String string) {
        this(string, null);
    }

    public ClassPathResource(@Nonnull @Nonempty String string, @Nullable ClassLoader classLoader) {
        ValueEnforcer.notEmpty(string, "Path");
        this.m_sPath = ClassPathResource.getWithoutClassPathPrefix(string);
        if (StringHelper.hasNoText(this.m_sPath)) {
            throw new IllegalArgumentException("No path specified after prefix: " + string);
        }
        this.m_aClassLoader = classLoader == null ? null : new WeakReference<ClassLoader>(classLoader);
    }

    private void writeObject(@Nonnull ObjectOutputStream objectOutputStream) throws IOException {
        if (this.m_aClassLoader != null) {
            throw new IOException("Cannot serialize a ClassPathResource that has a specific ClassLoader!");
        }
        objectOutputStream.writeUTF(this.m_sPath);
    }

    private void readObject(@Nonnull ObjectInputStream objectInputStream) throws IOException {
        this.m_sPath = objectInputStream.readUTF();
    }

    @Nullable
    public static String getWithoutClassPathPrefix(@Nullable String string) {
        if (StringHelper.startsWith((CharSequence)string, CLASSPATH_PREFIX_LONG)) {
            return string.substring(CLASSPATH_PREFIX_LONG.length());
        }
        if (StringHelper.startsWith((CharSequence)string, CLASSPATH_PREFIX_SHORT)) {
            return string.substring(CLASSPATH_PREFIX_SHORT.length());
        }
        return string;
    }

    public static boolean isExplicitClassPathResource(@Nullable String string) {
        return StringHelper.startsWith((CharSequence)string, CLASSPATH_PREFIX_LONG) || StringHelper.startsWith((CharSequence)string, CLASSPATH_PREFIX_SHORT);
    }

    @Nullable
    private ClassLoader _getSpecifiedClassLoader() {
        return this.m_aClassLoader == null ? null : (ClassLoader)this.m_aClassLoader.get();
    }

    @Override
    @Nonnull
    public String getResourceID() {
        URL uRL = this.getAsURL();
        return uRL == null ? this.m_sPath : uRL.toExternalForm();
    }

    @Override
    @Nonnull
    @Nonempty
    public String getPath() {
        return this.m_sPath;
    }

    @Nullable
    private static InputStream _getInputStream(@Nullable URL uRL) {
        return uRL == null ? null : URLResource.getInputStream(uRL);
    }

    @Nullable
    public static InputStream getInputStream(@Nonnull @Nonempty String string) {
        URL uRL = URLHelper.getClassPathURL(string);
        return ClassPathResource._getInputStream(uRL);
    }

    @Nullable
    public static InputStream getInputStream(@Nonnull @Nonempty String string, @Nonnull ClassLoader classLoader) {
        URL uRL = URLHelper.getClassPathURL(string, classLoader);
        return ClassPathResource._getInputStream(uRL);
    }

    @Override
    @Nullable
    public InputStream getInputStream() {
        URL uRL = this.getAsURL();
        return ClassPathResource._getInputStream(uRL);
    }

    @Nullable
    public InputStream getInputStreamNoCache(@Nonnull ClassLoader classLoader) {
        URL uRL = this.getAsURLNoCache(classLoader);
        return ClassPathResource._getInputStream(uRL);
    }

    @Override
    @Nullable
    public Reader getReader(@Nonnull Charset charset) {
        return StreamHelper.createReader(this.getInputStream(), charset);
    }

    @Nullable
    public Reader getReaderNoCache(@Nonnull ClassLoader classLoader, @Nonnull Charset charset) {
        return StreamHelper.createReader(this.getInputStreamNoCache(classLoader), charset);
    }

    @Override
    public boolean exists() {
        return this.getAsURL() != null;
    }

    public boolean existsNoCacheUsage() {
        return URLHelper.getClassPathURL(this.m_sPath) != null;
    }

    @Override
    @Nullable
    public URL getAsURL() {
        if (!this.m_bURLResolved) {
            ClassLoader classLoader = this._getSpecifiedClassLoader();
            this.m_aURL = classLoader == null ? URLHelper.getClassPathURL(this.m_sPath) : URLHelper.getClassPathURL(this.m_sPath, classLoader);
            this.m_bURLResolved = true;
        }
        return this.m_aURL;
    }

    @Nullable
    public URL getAsURLNoCache(@Nonnull ClassLoader classLoader) {
        return URLHelper.getClassPathURL(this.m_sPath, classLoader);
    }

    @Nullable
    public static File getAsFile(@Nonnull @Nonempty String string) {
        URL uRL = URLHelper.getClassPathURL(string);
        return URLHelper.getAsFileOrNull(uRL);
    }

    @Nullable
    public static File getAsFile(@Nonnull @Nonempty String string, @Nonnull ClassLoader classLoader) {
        URL uRL = URLHelper.getClassPathURL(string, classLoader);
        return URLHelper.getAsFileOrNull(uRL);
    }

    @Override
    @Nullable
    public File getAsFile() {
        URL uRL = this.getAsURL();
        return URLHelper.getAsFileOrNull(uRL);
    }

    @Nullable
    public File getAsFileNoCache(@Nonnull ClassLoader classLoader) {
        URL uRL = this.getAsURLNoCache(classLoader);
        return URLHelper.getAsFileOrNull(uRL);
    }

    public boolean canRead() {
        return this.getAsURL() != null;
    }

    public boolean canReadNoCache(@Nonnull ClassLoader classLoader) {
        return this.getAsURLNoCache(classLoader) != null;
    }

    @Override
    @Nonnull
    public ClassPathResource getReadableCloneForPath(@Nonnull String string) {
        return new ClassPathResource(string, this._getSpecifiedClassLoader());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ClassPathResource classPathResource = (ClassPathResource)object;
        return EqualsHelper.equals(this.m_sPath, classPathResource.m_sPath) && EqualsHelper.equals(this._getSpecifiedClassLoader(), classPathResource._getSpecifiedClassLoader());
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sPath).append(this.m_aClassLoader).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("cpPath", this.m_sPath).appendIfNotNull("classLoader", this._getSpecifiedClassLoader()).append("urlResolved", this.m_bURLResolved).append("URL", this.m_aURL).toString();
    }
}

