/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.math;

import com.helger.commons.CGlobal;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.iterate.IIterableIterator;
import com.helger.commons.math.FactorialHelper;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class CombinationGenerator<DATATYPE>
implements IIterableIterator<List<DATATYPE>> {
    private final DATATYPE[] m_aElements;
    private final int[] m_aIndexResult;
    private final BigInteger m_aTotalCombinations;
    private BigInteger m_aCombinationsLeft;
    private final boolean m_bUseLong;
    private final long m_nTotalCombinations;
    private long m_nCombinationsLeft;

    public CombinationGenerator(@Nonnull @Nonempty List<DATATYPE> list, @Nonnegative int n) {
        ValueEnforcer.notEmpty(list, "Elements");
        ValueEnforcer.isBetweenInclusive(n, "SlotCount", 0, list.size());
        this.m_aElements = list.toArray();
        this.m_aIndexResult = new int[n];
        BigInteger bigInteger = FactorialHelper.getAnyFactorialLinear(this.m_aElements.length);
        BigInteger bigInteger2 = FactorialHelper.getAnyFactorialLinear(n);
        BigInteger bigInteger3 = FactorialHelper.getAnyFactorialLinear(this.m_aElements.length - n);
        this.m_aTotalCombinations = bigInteger.divide(bigInteger2.multiply(bigInteger3));
        this.m_bUseLong = this.m_aTotalCombinations.compareTo(CGlobal.BIGINT_MAX_LONG) < 0;
        this.m_nTotalCombinations = this.m_bUseLong ? this.m_aTotalCombinations.longValue() : -1L;
        this.reset();
    }

    public void reset() {
        for (int i = 0; i < this.m_aIndexResult.length; ++i) {
            this.m_aIndexResult[i] = i;
        }
        this.m_aCombinationsLeft = this.m_aTotalCombinations;
        this.m_nCombinationsLeft = this.m_nTotalCombinations;
    }

    @Nonnull
    public BigInteger getCombinationsLeft() {
        return this.m_bUseLong ? BigInteger.valueOf(this.m_nCombinationsLeft) : this.m_aCombinationsLeft;
    }

    @Override
    public boolean hasNext() {
        return this.m_bUseLong ? this.m_nCombinationsLeft > 0L : this.m_aCombinationsLeft.compareTo(BigInteger.ZERO) > 0;
    }

    @Nonnull
    public BigInteger getTotalCombinations() {
        return this.m_aTotalCombinations;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<DATATYPE> next() {
        boolean bl;
        boolean bl2 = this.m_bUseLong ? this.m_nCombinationsLeft == this.m_nTotalCombinations : (bl = this.m_aCombinationsLeft.equals(this.m_aTotalCombinations));
        if (!bl) {
            int n = this.m_aElements.length;
            int n2 = this.m_aIndexResult.length;
            int n3 = n2 - 1;
            while (this.m_aIndexResult[n3] == n - n2 + n3) {
                --n3;
            }
            int n4 = n3;
            this.m_aIndexResult[n4] = this.m_aIndexResult[n4] + 1;
            int n5 = this.m_aIndexResult[n3];
            for (int i = n3 + 1; i < n2; ++i) {
                this.m_aIndexResult[i] = n5 + i - n3;
            }
        }
        if (this.m_bUseLong) {
            --this.m_nCombinationsLeft;
        } else {
            this.m_aCombinationsLeft = this.m_aCombinationsLeft.subtract(BigInteger.ONE);
        }
        ArrayList<DATATYPE> arrayList = new ArrayList<DATATYPE>(this.m_aIndexResult.length);
        for (int i : this.m_aIndexResult) {
            arrayList.add(this.m_aElements[i]);
        }
        return arrayList;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public Iterator<List<DATATYPE>> iterator() {
        return this;
    }

    @Nonnull
    public static <DATATYPE> List<List<DATATYPE>> getAllPermutations(@Nonnull @Nonempty List<DATATYPE> list, @Nonnegative int n) {
        ArrayList<List<DATATYPE>> arrayList = new ArrayList<List<DATATYPE>>();
        CombinationGenerator.addAllPermutations(list, n, arrayList);
        return arrayList;
    }

    public static <DATATYPE> void addAllPermutations(@Nonnull @Nonempty List<DATATYPE> list, @Nonnegative int n, @Nonnull Collection<List<DATATYPE>> collection) {
        for (List<DATATYPE> list2 : new CombinationGenerator<DATATYPE>(list, n)) {
            collection.add(list2);
        }
    }
}

