/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.microdom;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.microdom.IMicroDataAware;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class MicroDataAware
implements IMicroDataAware,
ICloneable<MicroDataAware> {
    private final StringBuilder m_aSB;

    public MicroDataAware(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isArrayOfsLen(cArray, n, n2);
        this.m_aSB = new StringBuilder(n2 + 16).append(cArray, n, n2);
    }

    public MicroDataAware(@Nullable CharSequence charSequence) {
        this.m_aSB = StringHelper.hasNoText(charSequence) ? new StringBuilder() : new StringBuilder(charSequence);
    }

    @Override
    @Nonnull
    public StringBuilder getData() {
        return this.m_aSB;
    }

    @Override
    public void setData(@Nullable CharSequence charSequence) {
        this.m_aSB.setLength(0);
        this.m_aSB.append(charSequence);
    }

    @Override
    public void appendData(@Nullable CharSequence charSequence) {
        this.m_aSB.append(charSequence);
    }

    @Override
    public void appendData(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        this.m_aSB.append(cArray, n, n2);
    }

    @Override
    public void appendData(char c) {
        this.m_aSB.append(c);
    }

    @Override
    public void prependData(@Nullable CharSequence charSequence) {
        this.m_aSB.insert(0, charSequence);
    }

    @Override
    public void prependData(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        this.m_aSB.insert(0, cArray, n, n2);
    }

    @Override
    public void prependData(char c) {
        this.m_aSB.insert(0, c);
    }

    @Override
    @Nonnull
    public MicroDataAware getClone() {
        return new MicroDataAware(this.m_aSB);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MicroDataAware microDataAware = (MicroDataAware)object;
        return EqualsHelper.equals(this.m_aSB, microDataAware.m_aSB);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aSB).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("data", this.m_aSB).toString();
    }
}

