/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.microdom;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.microdom.AbstractMicroNode;
import com.helger.commons.microdom.EMicroNodeType;
import com.helger.commons.microdom.IMicroEntityReference;
import com.helger.commons.microdom.IMicroNode;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class MicroEntityReference
extends AbstractMicroNode
implements IMicroEntityReference {
    private final String m_sName;

    public MicroEntityReference(@Nonnull @Nonempty String string) {
        this.m_sName = ValueEnforcer.notEmpty(string, "EntityReferenceName");
    }

    @Override
    @Nonnull
    public EMicroNodeType getType() {
        return EMicroNodeType.ENTITY_REFERENCE;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getNodeName() {
        return '&' + this.m_sName + ';';
    }

    @Override
    @Nonnull
    @Nonempty
    public String getNodeValue() {
        return this.m_sName;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getName() {
        return this.m_sName;
    }

    @Override
    @Nonnull
    public IMicroEntityReference getClone() {
        return new MicroEntityReference(this.m_sName);
    }

    @Override
    public boolean isEqualContent(@Nullable IMicroNode iMicroNode) {
        if (iMicroNode == this) {
            return true;
        }
        if (!(iMicroNode instanceof MicroEntityReference)) {
            return false;
        }
        MicroEntityReference microEntityReference = (MicroEntityReference)iMicroNode;
        return this.m_sName.equals(microEntityReference.m_sName);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("name", this.m_sName).toString();
    }
}

