/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.mime;

import com.helger.commons.annotation.IsSPIImplementation;
import com.helger.commons.microdom.IMicroElement;
import com.helger.commons.microdom.MicroElement;
import com.helger.commons.microdom.convert.IMicroTypeConverter;
import com.helger.commons.microdom.convert.IMicroTypeConverterRegistrarSPI;
import com.helger.commons.microdom.convert.IMicroTypeConverterRegistry;
import com.helger.commons.microdom.util.MicroHelper;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.mime.MimeTypeInfo;
import com.helger.commons.mime.MimeTypeParser;
import com.helger.commons.string.StringHelper;
import java.util.LinkedHashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
@IsSPIImplementation
public final class MimeTypeInfoMicroTypeConverterRegistrar
implements IMicroTypeConverterRegistrarSPI {
    @Override
    public void registerMicroTypeConverter(@Nonnull IMicroTypeConverterRegistry iMicroTypeConverterRegistry) {
        iMicroTypeConverterRegistry.registerMicroElementTypeConverter(MimeTypeInfo.class, new MimeTypeInfoMicroTypeConverter());
    }

    static final class MimeTypeInfoMicroTypeConverter
    implements IMicroTypeConverter {
        private static final String ELEMENT_MIMETYPE = "mime-type";
        private static final String ELEMENT_COMMENT = "comment";
        private static final String ELEMENT_PARENT_TYPE = "parent-type";
        private static final String ELEMENT_GLOB = "glob";
        private static final String ELEMENT_EXTENSION = "extension";
        private static final String ATTR_SOURCE = "source";

        MimeTypeInfoMicroTypeConverter() {
        }

        @Override
        @Nullable
        public MimeTypeInfo convertToNative(@Nonnull IMicroElement iMicroElement) {
            LinkedHashSet<String> linkedHashSet;
            LinkedHashSet<MimeTypeInfo.MimeTypeWithSource> linkedHashSet2 = new LinkedHashSet<MimeTypeInfo.MimeTypeWithSource>();
            for (IMicroElement serializable2 : iMicroElement.getAllChildElements(ELEMENT_MIMETYPE)) {
                linkedHashSet = MimeTypeParser.parseMimeType(serializable2.getTextContentTrimmed());
                String string = serializable2.getAttributeValue(ATTR_SOURCE);
                linkedHashSet2.add(new MimeTypeInfo.MimeTypeWithSource((IMimeType)((Object)linkedHashSet), string));
            }
            String string = MicroHelper.getChildTextContent(iMicroElement, ELEMENT_COMMENT);
            LinkedHashSet<String> linkedHashSet3 = new LinkedHashSet<String>();
            for (IMicroElement iMicroElement2 : iMicroElement.getAllChildElements(ELEMENT_PARENT_TYPE)) {
                linkedHashSet3.add(iMicroElement2.getTextContentTrimmed());
            }
            linkedHashSet = new LinkedHashSet<String>();
            for (IMicroElement iMicroElement3 : iMicroElement.getAllChildElements(ELEMENT_GLOB)) {
                linkedHashSet.add(iMicroElement3.getTextContentTrimmed());
            }
            LinkedHashSet<MimeTypeInfo.ExtensionWithSource> linkedHashSet4 = new LinkedHashSet<MimeTypeInfo.ExtensionWithSource>();
            for (IMicroElement iMicroElement4 : iMicroElement.getAllChildElements(ELEMENT_EXTENSION)) {
                String string2 = StringHelper.getNotNull(iMicroElement4.getTextContentTrimmed());
                String string3 = iMicroElement4.getAttributeValue(ATTR_SOURCE);
                linkedHashSet4.add(new MimeTypeInfo.ExtensionWithSource(string2, string3));
            }
            String string4 = iMicroElement.getAttributeValue(ATTR_SOURCE);
            return new MimeTypeInfo(linkedHashSet2, string, linkedHashSet3, linkedHashSet, linkedHashSet4, string4);
        }

        @Override
        @Nullable
        public IMicroElement convertToMicroElement(@Nonnull Object object, @Nullable String string, @Nonnull String string2) {
            MimeTypeInfo mimeTypeInfo = (MimeTypeInfo)object;
            MicroElement microElement = new MicroElement(string, string2);
            for (MimeTypeInfo.MimeTypeWithSource object2 : mimeTypeInfo.getAllMimeTypesWithSource()) {
                microElement.appendElement(string, ELEMENT_MIMETYPE).setAttribute(ATTR_SOURCE, object2.getSource()).appendText(object2.getMimeTypeAsString());
            }
            if (mimeTypeInfo.hasComment()) {
                microElement.appendElement(string, ELEMENT_COMMENT).appendText(mimeTypeInfo.getComment());
            }
            for (String string3 : mimeTypeInfo.getAllParentTypes()) {
                microElement.appendElement(string, ELEMENT_PARENT_TYPE).appendText(string3);
            }
            for (String string4 : mimeTypeInfo.getAllGlobs()) {
                microElement.appendElement(string, ELEMENT_GLOB).appendText(string4);
            }
            for (MimeTypeInfo.ExtensionWithSource extensionWithSource : mimeTypeInfo.getAllExtensionsWithSource()) {
                microElement.appendElement(string, ELEMENT_EXTENSION).setAttribute(ATTR_SOURCE, extensionWithSource.getSource()).appendText(extensionWithSource.getExtension());
            }
            microElement.setAttribute(ATTR_SOURCE, mimeTypeInfo.getSource());
            return microElement;
        }
    }
}

