/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.scope.spi;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.exception.mock.IMockException;
import com.helger.commons.lang.ServiceLoaderHelper;
import com.helger.commons.scope.IApplicationScope;
import com.helger.commons.scope.IGlobalScope;
import com.helger.commons.scope.IRequestScope;
import com.helger.commons.scope.ISessionApplicationScope;
import com.helger.commons.scope.ISessionScope;
import com.helger.commons.scope.spi.IApplicationScopeSPI;
import com.helger.commons.scope.spi.IGlobalScopeSPI;
import com.helger.commons.scope.spi.IRequestScopeSPI;
import com.helger.commons.scope.spi.ISessionApplicationScopeSPI;
import com.helger.commons.scope.spi.ISessionScopeSPI;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ScopeSPIManager {
    private static final Logger s_aLogger = LoggerFactory.getLogger(ScopeSPIManager.class);
    private static boolean s_bDefaultInstantiated = false;
    private final ReadWriteLock m_aRWLock = new ReentrantReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private List<IGlobalScopeSPI> m_aGlobalSPIs;
    @GuardedBy(value="m_aRWLock")
    private List<IApplicationScopeSPI> m_aApplicationSPIs;
    @GuardedBy(value="m_aRWLock")
    private List<ISessionScopeSPI> m_aSessionSPIs;
    @GuardedBy(value="m_aRWLock")
    private List<ISessionApplicationScopeSPI> m_aSessionApplicationSPIs;
    @GuardedBy(value="m_aRWLock")
    private List<IRequestScopeSPI> m_aRequestSPIs;

    private ScopeSPIManager() {
        this.reinitialize();
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static ScopeSPIManager getInstance() {
        ScopeSPIManager scopeSPIManager = SingletonHolder.s_aInstance;
        s_bDefaultInstantiated = true;
        return scopeSPIManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reinitialize() {
        this.m_aRWLock.writeLock().lock();
        try {
            this.m_aGlobalSPIs = ServiceLoaderHelper.getAllSPIImplementations(IGlobalScopeSPI.class);
            this.m_aApplicationSPIs = ServiceLoaderHelper.getAllSPIImplementations(IApplicationScopeSPI.class);
            this.m_aSessionSPIs = ServiceLoaderHelper.getAllSPIImplementations(ISessionScopeSPI.class);
            this.m_aSessionApplicationSPIs = ServiceLoaderHelper.getAllSPIImplementations(ISessionApplicationScopeSPI.class);
            this.m_aRequestSPIs = ServiceLoaderHelper.getAllSPIImplementations(IRequestScopeSPI.class);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("Reinitialized " + ScopeSPIManager.class.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public List<IGlobalScopeSPI> getAllGlobalScopeSPIs() {
        this.m_aRWLock.readLock().lock();
        try {
            List<IGlobalScopeSPI> list = CollectionHelper.newList(this.m_aGlobalSPIs);
            return list;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public List<IApplicationScopeSPI> getAllApplicationScopeSPIs() {
        this.m_aRWLock.readLock().lock();
        try {
            List<IApplicationScopeSPI> list = CollectionHelper.newList(this.m_aApplicationSPIs);
            return list;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public List<ISessionScopeSPI> getAllSessionScopeSPIs() {
        this.m_aRWLock.readLock().lock();
        try {
            List<ISessionScopeSPI> list = CollectionHelper.newList(this.m_aSessionSPIs);
            return list;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public List<ISessionApplicationScopeSPI> getAllSessionApplicationScopeSPIs() {
        this.m_aRWLock.readLock().lock();
        try {
            List<ISessionApplicationScopeSPI> list = CollectionHelper.newList(this.m_aSessionApplicationSPIs);
            return list;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public List<IRequestScopeSPI> getAllRequestScopeSPIs() {
        this.m_aRWLock.readLock().lock();
        try {
            List<IRequestScopeSPI> list = CollectionHelper.newList(this.m_aRequestSPIs);
            return list;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    public void onGlobalScopeBegin(@Nonnull IGlobalScope iGlobalScope) {
        for (IGlobalScopeSPI iGlobalScopeSPI : this.getAllGlobalScopeSPIs()) {
            try {
                iGlobalScopeSPI.onGlobalScopeBegin(iGlobalScope);
            }
            catch (Throwable throwable) {
                s_aLogger.error("Failed to invoke SPI method onGlobalScopeBegin on " + iGlobalScopeSPI + " with scope " + iGlobalScope, throwable instanceof IMockException ? null : throwable);
            }
        }
    }

    public void onGlobalScopeEnd(@Nonnull IGlobalScope iGlobalScope) {
        for (IGlobalScopeSPI iGlobalScopeSPI : this.getAllGlobalScopeSPIs()) {
            try {
                iGlobalScopeSPI.onGlobalScopeEnd(iGlobalScope);
            }
            catch (Throwable throwable) {
                s_aLogger.error("Failed to invoke SPI method onGlobalScopeEnd on " + iGlobalScopeSPI + " with scope " + iGlobalScope, throwable instanceof IMockException ? null : throwable);
            }
        }
    }

    public void onApplicationScopeBegin(@Nonnull IApplicationScope iApplicationScope) {
        for (IApplicationScopeSPI iApplicationScopeSPI : this.getAllApplicationScopeSPIs()) {
            try {
                iApplicationScopeSPI.onApplicationScopeBegin(iApplicationScope);
            }
            catch (Throwable throwable) {
                s_aLogger.error("Failed to invoke SPI method onApplicationScopeBegin on " + iApplicationScopeSPI + " with scope " + iApplicationScope, throwable instanceof IMockException ? null : throwable);
            }
        }
    }

    public void onApplicationScopeEnd(@Nonnull IApplicationScope iApplicationScope) {
        for (IApplicationScopeSPI iApplicationScopeSPI : this.getAllApplicationScopeSPIs()) {
            try {
                iApplicationScopeSPI.onApplicationScopeEnd(iApplicationScope);
            }
            catch (Throwable throwable) {
                s_aLogger.error("Failed to invoke SPI method onApplicationScopeEnd on " + iApplicationScopeSPI + " with scope " + iApplicationScope, throwable instanceof IMockException ? null : throwable);
            }
        }
    }

    public void onSessionScopeBegin(@Nonnull ISessionScope iSessionScope) {
        for (ISessionScopeSPI iSessionScopeSPI : this.getAllSessionScopeSPIs()) {
            try {
                iSessionScopeSPI.onSessionScopeBegin(iSessionScope);
            }
            catch (Throwable throwable) {
                s_aLogger.error("Failed to invoke SPI method onSessionScopeBegin on " + iSessionScopeSPI + " with scope " + iSessionScope, throwable instanceof IMockException ? null : throwable);
            }
        }
    }

    public void onSessionScopeEnd(@Nonnull ISessionScope iSessionScope) {
        for (ISessionScopeSPI iSessionScopeSPI : this.getAllSessionScopeSPIs()) {
            try {
                iSessionScopeSPI.onSessionScopeEnd(iSessionScope);
            }
            catch (Throwable throwable) {
                s_aLogger.error("Failed to invoke SPI method onSessionScopeEnd on " + iSessionScopeSPI + " with scope " + iSessionScope, throwable instanceof IMockException ? null : throwable);
            }
        }
    }

    public void onSessionApplicationScopeBegin(@Nonnull ISessionApplicationScope iSessionApplicationScope) {
        for (ISessionApplicationScopeSPI iSessionApplicationScopeSPI : this.getAllSessionApplicationScopeSPIs()) {
            try {
                iSessionApplicationScopeSPI.onSessionApplicationScopeBegin(iSessionApplicationScope);
            }
            catch (Throwable throwable) {
                s_aLogger.error("Failed to invoke SPI method onSessionApplicationScopeBegin on " + iSessionApplicationScopeSPI + " with scope " + iSessionApplicationScope, throwable instanceof IMockException ? null : throwable);
            }
        }
    }

    public void onSessionApplicationScopeEnd(@Nonnull ISessionApplicationScope iSessionApplicationScope) {
        for (ISessionApplicationScopeSPI iSessionApplicationScopeSPI : this.getAllSessionApplicationScopeSPIs()) {
            try {
                iSessionApplicationScopeSPI.onSessionApplicationScopeEnd(iSessionApplicationScope);
            }
            catch (Throwable throwable) {
                s_aLogger.error("Failed to invoke SPI method onSessionApplicationScopeEnd on " + iSessionApplicationScopeSPI + " with scope " + iSessionApplicationScope, throwable instanceof IMockException ? null : throwable);
            }
        }
    }

    public void onRequestScopeBegin(@Nonnull IRequestScope iRequestScope) {
        for (IRequestScopeSPI iRequestScopeSPI : this.getAllRequestScopeSPIs()) {
            try {
                iRequestScopeSPI.onRequestScopeBegin(iRequestScope);
            }
            catch (Throwable throwable) {
                s_aLogger.error("Failed to invoke SPI method onRequestScopeBegin on " + iRequestScopeSPI + " with scope " + iRequestScope, throwable instanceof IMockException ? null : throwable);
            }
        }
    }

    public void onRequestScopeEnd(@Nonnull IRequestScope iRequestScope) {
        for (IRequestScopeSPI iRequestScopeSPI : this.getAllRequestScopeSPIs()) {
            try {
                iRequestScopeSPI.onRequestScopeEnd(iRequestScope);
            }
            catch (Throwable throwable) {
                s_aLogger.error("Failed to invoke SPI method onRequestScopeEnd on " + iRequestScopeSPI + " with scope " + iRequestScope, throwable instanceof IMockException ? null : throwable);
            }
        }
    }

    private static final class SingletonHolder {
        static final ScopeSPIManager s_aInstance = new ScopeSPIManager();

        private SingletonHolder() {
        }
    }
}

