/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.vminit;

import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.cleanup.CommonsCleanup;
import com.helger.commons.exception.mock.IMockException;
import com.helger.commons.lang.ServiceLoaderHelper;
import com.helger.commons.vminit.IVirtualMachineEventSPI;
import java.util.List;

public final class VirtualMachineInitializer {
    private static final List<IVirtualMachineEventSPI> s_aSPIs = ServiceLoaderHelper.getAllSPIImplementations(IVirtualMachineEventSPI.class);
    private static volatile Thread s_aShutdownThread;
    private static final VirtualMachineInitializer s_aInstance;

    private VirtualMachineInitializer() {
    }

    private static void _init() {
        for (IVirtualMachineEventSPI iVirtualMachineEventSPI : s_aSPIs) {
            try {
                iVirtualMachineEventSPI.onVirtualMachineStart();
            }
            catch (Throwable throwable) {
                System.err.println("!!! Error running VM initializer SPI " + iVirtualMachineEventSPI);
                if (throwable instanceof IMockException) continue;
                throwable.printStackTrace(System.err);
            }
        }
    }

    private static void _done() {
        for (IVirtualMachineEventSPI iVirtualMachineEventSPI : s_aSPIs) {
            try {
                iVirtualMachineEventSPI.onVirtualMachineStop();
            }
            catch (Throwable throwable) {
                System.err.println("!!! Error running VM shutdown SPI " + iVirtualMachineEventSPI);
                if (throwable instanceof IMockException) continue;
                throwable.printStackTrace(System.err);
            }
        }
        CommonsCleanup.cleanup();
        s_aShutdownThread = null;
        s_aSPIs.clear();
    }

    @CodingStyleguideUnaware(value="FindBugs claims that we do need synchronized here!")
    public static synchronized void runInitialization() {
        if (s_aSPIs != null && !s_aSPIs.isEmpty()) {
            if (s_aShutdownThread != null) {
                throw new IllegalStateException("Already initialized!");
            }
            VirtualMachineInitializer._init();
            s_aShutdownThread = new Thread("VirtualMachineInitializer.shutdown"){

                @Override
                public void run() {
                    VirtualMachineInitializer._done();
                }
            };
            Runtime.getRuntime().addShutdownHook(s_aShutdownThread);
        }
    }

    static {
        s_aInstance = new VirtualMachineInitializer();
    }
}

