/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.xml;

import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.filter.AbstractFilter;
import com.helger.commons.filter.IFilter;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.xml.XMLHelper;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.w3c.dom.Element;

@NotThreadSafe
public class FilterElementWithNamespace
extends AbstractFilter<Element> {
    private final String m_sNamespaceURI;

    public FilterElementWithNamespace(@Nullable String string) {
        this(string, null);
    }

    public FilterElementWithNamespace(@Nullable String string, @Nullable IFilter<? super Element> iFilter) {
        super(iFilter);
        this.m_sNamespaceURI = string;
    }

    @Nullable
    public String getNamespaceURI() {
        return this.m_sNamespaceURI;
    }

    @Override
    public boolean matchesThisFilter(@Nullable Element element) {
        return element != null && XMLHelper.hasNamespaceURI(element, this.m_sNamespaceURI);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        FilterElementWithNamespace filterElementWithNamespace = (FilterElementWithNamespace)object;
        return EqualsHelper.equals(this.m_sNamespaceURI, filterElementWithNamespace.m_sNamespaceURI);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_sNamespaceURI).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("namespaceURI", this.m_sNamespaceURI).toString();
    }
}

