/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.xml;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.filter.AbstractFilter;
import com.helger.commons.filter.IFilter;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.w3c.dom.Element;

@NotThreadSafe
public final class FilterElementWithTagName
extends AbstractFilter<Element> {
    private final String m_sTagName;

    public FilterElementWithTagName(@Nonnull @Nonempty String string) {
        this(string, null);
    }

    public FilterElementWithTagName(@Nonnull @Nonempty String string, @Nullable IFilter<? super Element> iFilter) {
        super(iFilter);
        this.m_sTagName = ValueEnforcer.notNull(string, "TagName");
    }

    @Nonnull
    @Nonempty
    public String getTagName() {
        return this.m_sTagName;
    }

    @Override
    public boolean matchesThisFilter(@Nullable Element element) {
        return element != null && element.getNamespaceURI() == null && element.getTagName().equals(this.m_sTagName);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        FilterElementWithTagName filterElementWithTagName = (FilterElementWithTagName)object;
        return this.m_sTagName.equals(filterElementWithTagName.m_sTagName);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_sTagName).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("tagName", this.m_sTagName).toString();
    }
}

