/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.xml;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.exception.InitializationException;
import com.helger.commons.xml.EXMLVersion;
import com.helger.commons.xml.serialize.read.DOMReaderDefaultSettings;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;

public final class XMLFactory {
    public static final boolean DEFAULT_DOM_NAMESPACE_AWARE = true;
    public static final boolean DEFAULT_DOM_VALIDATING = false;
    public static final boolean DEFAULT_DOM_IGNORING_ELEMENT_CONTENT_WHITESPACE = false;
    public static final boolean DEFAULT_DOM_EXPAND_ENTITY_REFERENCES = true;
    public static final boolean DEFAULT_DOM_IGNORING_COMMENTS = true;
    public static final boolean DEFAULT_DOM_COALESCING = true;
    public static final boolean DEFAULT_DOM_XINCLUDE_AWARE = false;
    private static final DocumentBuilderFactory s_aDefaultDocBuilderFactory = XMLFactory.createDefaultDocumentBuilderFactory();
    private static final DocumentBuilder s_aDefaultDocBuilder = XMLFactory.createDocumentBuilder(s_aDefaultDocBuilderFactory);
    private static final XMLFactory s_aInstance = new XMLFactory();

    private XMLFactory() {
    }

    @Nonnull
    public static DocumentBuilderFactory createDefaultDocumentBuilderFactory() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setIgnoringElementContentWhitespace(false);
        documentBuilderFactory.setExpandEntityReferences(true);
        documentBuilderFactory.setIgnoringComments(true);
        documentBuilderFactory.setCoalescing(true);
        try {
            documentBuilderFactory.setXIncludeAware(false);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return documentBuilderFactory;
    }

    @Nonnull
    public static DocumentBuilderFactory createDocumentBuilderFactory(@Nonnull Schema schema) {
        ValueEnforcer.notNull(schema, "Schema");
        DocumentBuilderFactory documentBuilderFactory = XMLFactory.createDefaultDocumentBuilderFactory();
        documentBuilderFactory.setSchema(schema);
        return documentBuilderFactory;
    }

    @Nonnull
    public static DocumentBuilderFactory getDocumentBuilderFactory() {
        return s_aDefaultDocBuilderFactory;
    }

    @Nonnull
    public static DocumentBuilder getDocumentBuilder() {
        return s_aDefaultDocBuilder;
    }

    @Nonnull
    public static DOMImplementation getDOMImplementation() {
        return s_aDefaultDocBuilder.getDOMImplementation();
    }

    @Nonnull
    public static DocumentBuilder createDocumentBuilder() {
        return XMLFactory.createDocumentBuilder(s_aDefaultDocBuilderFactory);
    }

    @Nonnull
    public static DocumentBuilder createDocumentBuilder(@Nonnull Schema schema) {
        return XMLFactory.createDocumentBuilder(XMLFactory.createDocumentBuilderFactory(schema));
    }

    @Nonnull
    public static DocumentBuilder createDocumentBuilder(@Nonnull DocumentBuilderFactory documentBuilderFactory) {
        ValueEnforcer.notNull(documentBuilderFactory, "DocBuilderFactory");
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(DOMReaderDefaultSettings.getErrorHandler());
            return documentBuilder;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new InitializationException("Failed to create document builder", parserConfigurationException);
        }
    }

    @Nonnull
    public static Document newDocument() {
        return XMLFactory.newDocument(s_aDefaultDocBuilder, null);
    }

    @Nonnull
    public static Document newDocument(@Nonnull DocumentBuilder documentBuilder) {
        return XMLFactory.newDocument(documentBuilder, null);
    }

    @Nonnull
    public static Document newDocument(@Nullable EXMLVersion eXMLVersion) {
        return XMLFactory.newDocument(s_aDefaultDocBuilder, eXMLVersion);
    }

    @Nonnull
    public static Document newDocument(@Nonnull DocumentBuilder documentBuilder, @Nullable EXMLVersion eXMLVersion) {
        ValueEnforcer.notNull(documentBuilder, "DocBuilder");
        Document document = documentBuilder.newDocument();
        document.setXmlVersion((eXMLVersion != null ? eXMLVersion : EXMLVersion.XML_10).getVersion());
        return document;
    }

    @Nonnull
    public static Document newDocument(@Nonnull String string, @Nullable String string2, @Nullable String string3) {
        return XMLFactory.newDocument(null, string, string2, string3);
    }

    @Nonnull
    public static Document newDocument(@Nullable EXMLVersion eXMLVersion, @Nonnull String string, @Nullable String string2, @Nullable String string3) {
        return XMLFactory.newDocument(s_aDefaultDocBuilder, eXMLVersion, string, string2, string3);
    }

    @Nonnull
    public static Document newDocument(@Nonnull DocumentBuilder documentBuilder, @Nullable EXMLVersion eXMLVersion, @Nonnull String string, @Nullable String string2, @Nullable String string3) {
        ValueEnforcer.notNull(documentBuilder, "DocBuilder");
        DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
        DocumentType documentType = dOMImplementation.createDocumentType(string, string2, string3);
        Document document = dOMImplementation.createDocument(string3, string, documentType);
        document.setXmlVersion((eXMLVersion != null ? eXMLVersion : EXMLVersion.XML_10).getVersion());
        return document;
    }
}

