/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.xml.namespace;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.multimap.IMultiMapSetBased;
import com.helger.commons.collection.multimap.MultiHashMapHashSetBased;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.xml.namespace.AbstractNamespaceContext;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class MapBasedNamespaceContext
extends AbstractNamespaceContext {
    private String m_sDefaultNamespaceURI;
    private final Map<String, String> m_aPrefix2NS = new LinkedHashMap<String, String>();
    private final IMultiMapSetBased<String, String> m_aNS2Prefix = new MultiHashMapHashSetBased<String, String>();

    @Override
    @Nullable
    public String getDefaultNamespaceURI() {
        return this.m_sDefaultNamespaceURI;
    }

    @Nonnull
    public MapBasedNamespaceContext setDefaultNamespaceURI(@Nonnull String string) {
        return this.addMapping("", string);
    }

    @Nonnull
    public MapBasedNamespaceContext addMapping(@Nonnull String string, @Nonnull String string2) {
        ValueEnforcer.notNull(string, "Prefix");
        ValueEnforcer.notNull(string2, "NamespaceURI");
        if (this.m_aPrefix2NS.containsKey(string)) {
            throw new IllegalArgumentException("The prefix '" + string + "' is already registered!");
        }
        if (string.equals("")) {
            this.m_sDefaultNamespaceURI = string2;
        }
        this.m_aPrefix2NS.put(string, string2);
        this.m_aNS2Prefix.putSingle(string2, string);
        return this;
    }

    @Nonnull
    public EChange removeMapping(@Nullable String string) {
        String string2 = this.m_aPrefix2NS.remove(string);
        if (string2 == null) {
            return EChange.UNCHANGED;
        }
        if (this.m_aNS2Prefix.removeSingle(string2, string).isUnchanged()) {
            throw new IllegalStateException("Internal inconsistency!");
        }
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public Iterator<String> getCustomPrefixes(@Nonnull String string) {
        Set set = (Set)this.m_aNS2Prefix.get(string);
        return set == null ? null : set.iterator();
    }

    @Override
    @Nullable
    public String getCustomPrefix(@Nonnull String string) {
        Set set = (Set)this.m_aNS2Prefix.get(string);
        return (String)CollectionHelper.getFirstElement(set);
    }

    @Override
    @Nullable
    public String getCustomNamespaceURI(@Nonnull String string) {
        return this.m_aPrefix2NS.get(string);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Map<String, String> getPrefixToNamespaceURIMap() {
        return CollectionHelper.newOrderedMap(this.m_aPrefix2NS);
    }

    public boolean hasAnyMapping() {
        return !this.m_aPrefix2NS.isEmpty();
    }

    @Nonnegative
    public int getMappingCount() {
        return this.m_aPrefix2NS.size();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MapBasedNamespaceContext mapBasedNamespaceContext = (MapBasedNamespaceContext)object;
        return EqualsHelper.equals(this.m_sDefaultNamespaceURI, mapBasedNamespaceContext.m_sDefaultNamespaceURI) && this.m_aPrefix2NS.equals(mapBasedNamespaceContext.m_aPrefix2NS) && this.m_aNS2Prefix.equals(mapBasedNamespaceContext.m_aNS2Prefix);
    }

    public int hashCode() {
        return ((HashCodeGenerator)((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_sDefaultNamespaceURI).append((Map)this.m_aPrefix2NS)).append(this.m_aNS2Prefix)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).appendIfNotNull("defaultNS", this.m_sDefaultNamespaceURI).append("prefix2NS", this.m_aPrefix2NS).append("ns2Prefix2", this.m_aNS2Prefix).toString();
    }
}

