/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.xml.sax;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.string.ToStringGenerator;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class ReadableResourceSAXInputSource
extends InputSource {
    private static final Logger s_aLogger = LoggerFactory.getLogger(ReadableResourceSAXInputSource.class);
    private final IHasInputStream m_aISP;

    public ReadableResourceSAXInputSource(@Nonnull IReadableResource iReadableResource) {
        this(iReadableResource, iReadableResource.getResourceID());
    }

    public ReadableResourceSAXInputSource(@Nonnull IHasInputStream iHasInputStream, @Nullable String string) {
        this.m_aISP = ValueEnforcer.notNull(iHasInputStream, "InputStreamProvider");
        this.setSystemId(string);
    }

    @Nonnull
    public IHasInputStream getInputStreamProvider() {
        return this.m_aISP;
    }

    @Override
    public InputStream getByteStream() {
        InputStream inputStream = this.m_aISP.getInputStream();
        if (inputStream == null) {
            s_aLogger.warn("Failed to open input stream for " + this.m_aISP);
        }
        return inputStream;
    }

    public String toString() {
        return new ToStringGenerator(this).append("resource", this.m_aISP).append("systemID", this.getSystemId()).toString();
    }
}

