/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.cache;

import com.helger.commons.cache.AbstractCache;
import com.helger.commons.convert.IConverter;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class CacheWithConversion<KEYTYPE, VALUETYPE>
extends AbstractCache<KEYTYPE, VALUETYPE> {
    public CacheWithConversion(@Nonnull String string) {
        this(-1, string);
    }

    public CacheWithConversion(@CheckForSigned int n, @Nonnull String string) {
        super(n, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public final VALUETYPE getFromCache(@Nonnull KEYTYPE KEYTYPE, @Nonnull IConverter<KEYTYPE, VALUETYPE> iConverter) {
        Object VALUETYPE = super.getFromCacheNoStats(KEYTYPE);
        if (VALUETYPE == null) {
            this.m_aRWLock.writeLock().lock();
            try {
                VALUETYPE = super.getFromCacheNoStatsNotLocked(KEYTYPE);
                if (VALUETYPE == null) {
                    VALUETYPE = iConverter.convert(KEYTYPE);
                    if (VALUETYPE == null) {
                        throw new IllegalStateException("The converter returned a null object for the key '" + KEYTYPE + "'");
                    }
                    super.putInCacheNotLocked(KEYTYPE, VALUETYPE);
                    this.m_aCacheAccessStats.cacheMiss();
                }
                this.m_aCacheAccessStats.cacheHit();
            }
            finally {
                this.m_aRWLock.writeLock().unlock();
            }
        } else {
            this.m_aCacheAccessStats.cacheHit();
        }
        return VALUETYPE;
    }
}

