/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.concurrent.collector;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.callback.IThrowingRunnableWithParameter;
import com.helger.commons.concurrent.collector.AbstractConcurrentCollector;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.state.ESuccess;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentCollectorMultiple<DATATYPE>
extends AbstractConcurrentCollector<DATATYPE> {
    public static final int DEFAULT_MAX_PERFORM_COUNT = 50;
    private static final Logger s_aLogger = LoggerFactory.getLogger(ConcurrentCollectorMultiple.class);
    @Nonnegative
    private final int m_nMaxPerformCount;
    private IThrowingRunnableWithParameter<List<DATATYPE>> m_aPerformer;

    public ConcurrentCollectorMultiple() {
        this(100, 50);
    }

    public ConcurrentCollectorMultiple(@Nonnegative int n, @Nonnegative int n2) {
        super(n);
        ValueEnforcer.isGT0(n2, "MaxPerformCount");
        if (n2 > n) {
            throw new IllegalArgumentException("max perform size is illegal: " + n2);
        }
        this.m_nMaxPerformCount = n2;
    }

    @Nullable
    protected final IThrowingRunnableWithParameter<List<DATATYPE>> getPerformer() {
        return this.m_aPerformer;
    }

    protected final void setPerformer(@Nonnull IThrowingRunnableWithParameter<List<DATATYPE>> iThrowingRunnableWithParameter) {
        if (this.m_aPerformer != null) {
            throw new IllegalStateException("Another performer is already set!");
        }
        this.m_aPerformer = ValueEnforcer.notNull(iThrowingRunnableWithParameter, "Performer");
    }

    @Nonnull
    private ESuccess _perform(@Nonnull List<DATATYPE> list) {
        if (!list.isEmpty()) {
            try {
                this.m_aPerformer.run(list);
            }
            catch (Throwable throwable) {
                s_aLogger.error("Failed to perform actions on " + list.size() + " objects with performer " + this.m_aPerformer + " - objects are lost!", throwable);
                return ESuccess.FAILURE;
            }
            list.clear();
        }
        return ESuccess.SUCCESS;
    }

    @Override
    public final void run() {
        if (this.m_aPerformer == null) {
            throw new IllegalStateException("No performer set!");
        }
        try {
            Object e;
            ArrayList arrayList = new ArrayList();
            boolean bl = false;
            while ((e = this.m_aQueue.take()) != STOP_QUEUE_OBJECT) {
                arrayList.add(GenericReflection.uncheckedCast(e));
                while (arrayList.size() < this.m_nMaxPerformCount && !this.m_aQueue.isEmpty()) {
                    e = this.m_aQueue.take();
                    if (e == STOP_QUEUE_OBJECT) {
                        bl = true;
                        break;
                    }
                    arrayList.add(GenericReflection.uncheckedCast(e));
                }
                this._perform(arrayList);
                if (!bl) continue;
                break;
            }
            this._perform(arrayList);
        }
        catch (Throwable throwable) {
            s_aLogger.error("Error taking elements from queue - queue has been interrupted!!!", throwable);
        }
    }
}

