/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.factory;

import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.factory.IFactory;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FactoryNewInstance<DATATYPE>
implements IFactory<DATATYPE>,
Serializable {
    private final Class<? extends DATATYPE> m_aClass;

    public FactoryNewInstance(@Nullable Class<? extends DATATYPE> clazz, boolean bl) {
        if (bl && !ClassHelper.isInstancableClass(clazz)) {
            throw new IllegalArgumentException("The passed class '" + clazz + "' is not instancable or doesn't have a no-argument constructor!");
        }
        this.m_aClass = clazz;
    }

    @Nullable
    public Class<? extends DATATYPE> getFactoryClass() {
        return this.m_aClass;
    }

    @Override
    @Nullable
    public DATATYPE create() {
        return GenericReflection.newInstance(this.m_aClass);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        FactoryNewInstance factoryNewInstance = (FactoryNewInstance)object;
        return EqualsHelper.equals(this.m_aClass, factoryNewInstance.m_aClass);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aClass).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("class", this.m_aClass).toString();
    }

    @Nonnull
    public static <DATATYPE> FactoryNewInstance<DATATYPE> create(@Nullable Class<DATATYPE> clazz) {
        return FactoryNewInstance.create(clazz, false);
    }

    @Nonnull
    public static <DATATYPE> FactoryNewInstance<DATATYPE> create(@Nullable Class<DATATYPE> clazz, boolean bl) {
        return new FactoryNewInstance<DATATYPE>(clazz, bl);
    }
}

