/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.file.filter;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.io.file.filter.AbstractFileFilter;
import com.helger.commons.string.ToStringGenerator;
import java.io.File;
import java.io.FileFilter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class FileFilterFromFileFilter
extends AbstractFileFilter {
    private final FileFilter m_aFileFilter;

    public FileFilterFromFileFilter(@Nonnull FileFilter fileFilter) {
        this.m_aFileFilter = ValueEnforcer.notNull(fileFilter, "FileFilter");
    }

    @Nonnull
    public FileFilter getFileFilter() {
        return this.m_aFileFilter;
    }

    @Override
    public boolean matchesThisFilter(@Nullable File file) {
        return file != null && this.m_aFileFilter.accept(file);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("FileFilter", this.m_aFileFilter).toString();
    }
}

