/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.lang;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.lang.ClassLoaderHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class ServiceLoaderHelper {
    private static final Logger s_aLogger = LoggerFactory.getLogger(ServiceLoaderHelper.class);

    private ServiceLoaderHelper() {
    }

    @Nonnull
    private static ClassLoader _getDefaultClassLoader() {
        return ClassLoaderHelper.getDefaultClassLoader();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <T> List<T> getAllSPIImplementations(@Nonnull Class<T> clazz) {
        return ServiceLoaderHelper.getAllSPIImplementations(clazz, ServiceLoaderHelper._getDefaultClassLoader(), null);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <T> List<T> getAllSPIImplementations(@Nonnull Class<T> clazz, @Nonnull ClassLoader classLoader) {
        return ServiceLoaderHelper.getAllSPIImplementations(clazz, classLoader, null);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <T> List<T> getAllSPIImplementations(@Nonnull Class<T> clazz, @Nullable Logger logger) {
        return ServiceLoaderHelper.getAllSPIImplementations(clazz, ServiceLoaderHelper._getDefaultClassLoader(), logger);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <T> List<T> getAllSPIImplementations(@Nonnull Class<T> clazz, @Nonnull ClassLoader classLoader, @Nullable Logger logger) {
        Logger logger2;
        ValueEnforcer.notNull(clazz, "SPIClass");
        ValueEnforcer.notNull(classLoader, "ClassLoader");
        Logger logger3 = logger2 = logger != null ? logger : s_aLogger;
        if (logger2.isDebugEnabled()) {
            logger2.debug("Trying to load all SPI implementations of " + clazz);
        }
        ServiceLoader<T> serviceLoader = ServiceLoader.load(clazz, classLoader);
        ArrayList<T> arrayList = new ArrayList<T>();
        Iterator<T> iterator = serviceLoader.iterator();
        while (iterator.hasNext()) {
            try {
                arrayList.add(iterator.next());
            }
            catch (Throwable throwable) {
                logger2.error("Unable to load an SPI implementation of " + clazz, throwable);
            }
        }
        if (logger2.isDebugEnabled()) {
            logger2.debug("Finished loading all SPI implementations of " + clazz + " --> returning " + arrayList.size() + " instances");
        }
        return arrayList;
    }

    @Nullable
    public static <T> T getFirstSPIImplementation(@Nonnull Class<T> clazz) {
        return ServiceLoaderHelper.getFirstSPIImplementation(clazz, ServiceLoaderHelper._getDefaultClassLoader(), null);
    }

    @Nullable
    public static <T> T getFirstSPIImplementation(@Nonnull Class<T> clazz, @Nonnull ClassLoader classLoader) {
        return ServiceLoaderHelper.getFirstSPIImplementation(clazz, classLoader, null);
    }

    @Nullable
    public static <T> T getFirstSPIImplementation(@Nonnull Class<T> clazz, @Nullable Logger logger) {
        return ServiceLoaderHelper.getFirstSPIImplementation(clazz, ServiceLoaderHelper._getDefaultClassLoader(), logger);
    }

    @Nullable
    public static <T> T getFirstSPIImplementation(@Nonnull Class<T> clazz, @Nonnull ClassLoader classLoader, @Nullable Logger logger) {
        Logger logger2 = logger != null ? logger : s_aLogger;
        List<T> list = ServiceLoaderHelper.getAllSPIImplementations(clazz, classLoader, logger2);
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            logger2.warn("Requested only one SPI implementation of " + clazz + " but found " + list.size() + ": " + list);
        }
        return list.get(0);
    }
}

