/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.locale.country;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.locale.LocaleCache;
import com.helger.commons.locale.LocaleHelper;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class CountryCache {
    private static final Logger s_aLogger = LoggerFactory.getLogger(CountryCache.class);
    private static boolean s_bDefaultInstantiated = false;
    private final ReadWriteLock m_aRWLock = new ReentrantReadWriteLock();
    private final Set<String> m_aCountries = new HashSet<String>();

    private CountryCache() {
        this.reinitialize();
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static CountryCache getInstance() {
        CountryCache countryCache = SingletonHolder.s_aInstance;
        s_bDefaultInstantiated = true;
        return countryCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    EChange addCountry(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Country");
        String string2 = LocaleHelper.getValidCountryCode(string);
        if (string2 == null) {
            throw new IllegalArgumentException("illegal country code '" + string + "'");
        }
        if (!string.equals(string2)) {
            throw new IllegalArgumentException("invalid casing of '" + string + "'");
        }
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = EChange.valueOf(this.m_aCountries.add(string2));
            return eChange;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    @Nullable
    public Locale getCountry(@Nullable Locale locale) {
        return locale == null ? null : this.getCountry(locale.getCountry());
    }

    @Nullable
    public Locale getCountry(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        if (string.indexOf(95) >= 0) {
            return this.getCountry(LocaleCache.getInstance().getLocale(string));
        }
        String string2 = LocaleHelper.getValidCountryCode(string);
        if (!this.containsCountry(string2)) {
            s_aLogger.warn("Trying to retrieve unsupported country " + string);
        }
        return LocaleCache.getInstance().getLocale("", string2, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public Set<String> getAllCountries() {
        this.m_aRWLock.readLock().lock();
        try {
            Set<String> set = CollectionHelper.newSet(this.m_aCountries);
            return set;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public Set<Locale> getAllCountryLocales() {
        HashSet<Locale> hashSet = new HashSet<Locale>();
        for (String string : this.getAllCountries()) {
            hashSet.add(LocaleCache.getInstance().getLocale("", string, ""));
        }
        return hashSet;
    }

    public boolean containsCountry(@Nullable Locale locale) {
        return locale != null && this.containsCountry(locale.getCountry());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsCountry(@Nullable String string) {
        if (string == null) {
            return false;
        }
        String string2 = LocaleHelper.getValidCountryCode(string);
        if (string2 == null) {
            return false;
        }
        this.m_aRWLock.readLock().lock();
        try {
            boolean bl = this.m_aCountries.contains(string2);
            return bl;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reinitialize() {
        this.m_aRWLock.writeLock().lock();
        try {
            this.m_aCountries.clear();
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        for (Locale locale : LocaleCache.getInstance().getAllLocales()) {
            String string = locale.getCountry();
            if (!StringHelper.hasText(string)) continue;
            this.addCountry(string);
        }
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("Reinitialized " + CountryCache.class.getName());
        }
    }

    private static final class SingletonHolder {
        static final CountryCache s_aInstance = new CountryCache();

        private SingletonHolder() {
        }
    }
}

