/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.scope.mgr;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.scope.IApplicationScope;
import com.helger.commons.scope.IGlobalScope;
import com.helger.commons.scope.IRequestScope;
import com.helger.commons.scope.ISessionApplicationScope;
import com.helger.commons.scope.ISessionScope;
import com.helger.commons.scope.ScopeHelper;
import com.helger.commons.scope.mgr.MetaScopeFactory;
import com.helger.commons.scope.mgr.ScopeSessionManager;
import com.helger.commons.scope.spi.ScopeSPIManager;
import com.helger.commons.string.StringHelper;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ScopeManager {
    public static final String SCOPE_ATTRIBUTE_PREFIX_INTERNAL = "$ph.";
    public static final boolean DEFAULT_CREATE_SCOPE = true;
    private static final Logger s_aLogger = LoggerFactory.getLogger(ScopeManager.class);
    private static final String REQ_APPLICATION_ID = "$ph.applicationscope";
    private static final Lock s_aGlobalLock = new ReentrantLock();
    @GuardedBy(value="s_aGlobalLock")
    private static volatile IGlobalScope s_aGlobalScope;
    private static final ThreadLocal<IRequestScope> s_aRequestScope;
    private static final ScopeManager s_aInstance;

    private ScopeManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setGlobalScope(@Nonnull IGlobalScope iGlobalScope) {
        ValueEnforcer.notNull(iGlobalScope, "GlobalScope");
        s_aGlobalLock.lock();
        try {
            if (s_aGlobalScope != null) {
                throw new IllegalStateException("Another global scope with ID '" + s_aGlobalScope.getID() + "' is already present");
            }
            s_aGlobalScope = iGlobalScope;
            iGlobalScope.initScope();
            if (ScopeHelper.debugGlobalScopeLifeCycle(s_aLogger)) {
                s_aLogger.info("Global scope '" + iGlobalScope.getID() + "' initialized!", ScopeHelper.getDebugStackTrace());
            }
            ScopeSPIManager.getInstance().onGlobalScopeBegin(iGlobalScope);
        }
        finally {
            s_aGlobalLock.unlock();
        }
    }

    @Nonnull
    public static IGlobalScope onGlobalBegin(@Nonnull @Nonempty String string) {
        IGlobalScope iGlobalScope = MetaScopeFactory.getScopeFactory().createGlobalScope(string);
        ScopeManager.setGlobalScope(iGlobalScope);
        return iGlobalScope;
    }

    @Nullable
    public static IGlobalScope getGlobalScopeOrNull() {
        IGlobalScope iGlobalScope = s_aGlobalScope;
        if (iGlobalScope != null && iGlobalScope.isValid()) {
            return iGlobalScope;
        }
        return null;
    }

    public static boolean isGlobalScopePresent() {
        return ScopeManager.getGlobalScopeOrNull() != null;
    }

    @Nonnull
    public static IGlobalScope getGlobalScope() {
        IGlobalScope iGlobalScope = ScopeManager.getGlobalScopeOrNull();
        if (iGlobalScope == null) {
            throw new IllegalStateException("No global scope object has been set!");
        }
        return iGlobalScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onGlobalEnd() {
        s_aGlobalLock.lock();
        try {
            if (s_aGlobalScope != null) {
                ScopeSPIManager.getInstance().onGlobalScopeEnd(s_aGlobalScope);
                String string = s_aGlobalScope.getID();
                s_aGlobalScope.destroyScope();
                s_aGlobalScope = null;
                if (ScopeHelper.debugGlobalScopeLifeCycle(s_aLogger)) {
                    s_aLogger.info("Global scope '" + string + "' shut down!", ScopeHelper.getDebugStackTrace());
                }
            } else {
                s_aLogger.warn("No global scope present that could be shut down!");
            }
        }
        finally {
            s_aGlobalLock.unlock();
        }
    }

    @Nullable
    public static String getRequestApplicationID(@Nonnull IRequestScope iRequestScope) {
        return iRequestScope.getAttributeAsString(REQ_APPLICATION_ID);
    }

    @Nonnull
    public static String getRequestApplicationID() {
        String string = ScopeManager.getRequestApplicationID(ScopeManager.getRequestScope());
        if (string == null) {
            throw new IllegalStateException("Weird state - no appid!");
        }
        return string;
    }

    @Nonnull
    public static IApplicationScope getApplicationScope() {
        return ScopeManager.getApplicationScope(true);
    }

    @Nullable
    public static IApplicationScope getApplicationScope(boolean bl) {
        return ScopeManager.getApplicationScope(ScopeManager.getRequestApplicationID(), bl);
    }

    @Nonnull
    public static IApplicationScope getApplicationScope(@Nonnull @Nonempty String string) {
        return ScopeManager.getApplicationScope(string, true);
    }

    @Nullable
    public static IApplicationScope getApplicationScope(@Nonnull @Nonempty String string, boolean bl) {
        return ScopeManager.getGlobalScope().getApplicationScope(string, bl);
    }

    @Nonnull
    public static ISessionScope getSessionScope() {
        return ScopeManager.getSessionScope(true);
    }

    @Nullable
    public static ISessionScope getSessionScope(boolean bl) {
        IRequestScope iRequestScope = ScopeManager.getRequestScopeOrNull();
        if (iRequestScope != null) {
            String string;
            ScopeSessionManager scopeSessionManager = ScopeSessionManager.getInstance();
            ISessionScope iSessionScope = scopeSessionManager.getSessionScopeOfID(string = iRequestScope.getSessionID(bl));
            if (iSessionScope == null && bl) {
                if (string == null) {
                    throw new IllegalStateException("Cannot create a SessionScope without a known session ID!");
                }
                iSessionScope = MetaScopeFactory.getScopeFactory().createSessionScope(string);
                scopeSessionManager.onScopeBegin(iSessionScope);
            }
            return iSessionScope;
        }
        if (bl) {
            throw new IllegalStateException("No request scope is present, so no session scope can be created!");
        }
        return null;
    }

    public static void destroySessionScope(@Nonnull ISessionScope iSessionScope) {
        ValueEnforcer.notNull(iSessionScope, "SessionScope");
        ScopeSessionManager.getInstance().onScopeEnd(iSessionScope);
    }

    @Nonnull
    public static ISessionApplicationScope getSessionApplicationScope() {
        return ScopeManager.getSessionApplicationScope(true);
    }

    @Nullable
    public static ISessionApplicationScope getSessionApplicationScope(boolean bl) {
        return ScopeManager.getSessionApplicationScope(ScopeManager.getRequestApplicationID(), bl);
    }

    @Nonnull
    public static ISessionApplicationScope getSessionApplicationScope(@Nonnull @Nonempty String string) {
        return ScopeManager.getSessionApplicationScope(string, true);
    }

    @Nullable
    public static ISessionApplicationScope getSessionApplicationScope(@Nonnull @Nonempty String string, boolean bl) {
        ISessionScope iSessionScope = ScopeManager.getSessionScope(bl);
        return iSessionScope == null ? null : iSessionScope.getSessionApplicationScope(string, bl);
    }

    public static void setAndInitRequestScope(@Nonnull @Nonempty String string, @Nonnull IRequestScope iRequestScope) {
        ValueEnforcer.notEmpty(string, "ApplicationID");
        ValueEnforcer.notNull(iRequestScope, "RequestScope");
        if (!ScopeManager.isGlobalScopePresent()) {
            throw new IllegalStateException("No global context present! May be the global context listener is not installed?");
        }
        IRequestScope iRequestScope2 = s_aRequestScope.get();
        if (iRequestScope2 != null) {
            s_aLogger.warn("A request scope is already present - will overwrite it: " + iRequestScope2.toString());
            if (iRequestScope2.isValid()) {
                s_aLogger.warn("Destroying the old request scope before the new one gets initialized!");
                ScopeManager._destroyRequestScope(iRequestScope2);
            }
        }
        s_aRequestScope.set(iRequestScope);
        if (iRequestScope.setAttribute(REQ_APPLICATION_ID, string).isUnchanged()) {
            s_aLogger.warn("Failed to set the application ID '" + string + "' into the request scope '" + iRequestScope.getID() + "'");
        }
        iRequestScope.initScope();
        ScopeSPIManager.getInstance().onRequestScopeBegin(iRequestScope);
    }

    @Nonnull
    public static IRequestScope onRequestBegin(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull @Nonempty String string3) {
        IRequestScope iRequestScope = MetaScopeFactory.getScopeFactory().createRequestScope(string2, string3);
        ScopeManager.setAndInitRequestScope(string, iRequestScope);
        return iRequestScope;
    }

    @Nullable
    public static IRequestScope getRequestScopeOrNull() {
        return s_aRequestScope.get();
    }

    public static boolean isRequestScopePresent() {
        return ScopeManager.getRequestScopeOrNull() != null;
    }

    @Nonnull
    public static IRequestScope getRequestScope() {
        IRequestScope iRequestScope = ScopeManager.getRequestScopeOrNull();
        if (iRequestScope == null) {
            throw new IllegalStateException("No request scope is available.");
        }
        return iRequestScope;
    }

    private static void _destroyRequestScope(@Nonnull IRequestScope iRequestScope) {
        ScopeSPIManager.getInstance().onRequestScopeEnd(iRequestScope);
        iRequestScope.destroyScope();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onRequestEnd() {
        IRequestScope iRequestScope = ScopeManager.getRequestScopeOrNull();
        try {
            if (iRequestScope != null) {
                ScopeManager._destroyRequestScope(iRequestScope);
            } else {
                s_aLogger.warn("No request scope present that could be ended!");
            }
        }
        finally {
            s_aRequestScope.remove();
        }
    }

    public static boolean isInternalAttribute(@Nullable String string) {
        return StringHelper.startsWith((CharSequence)string, SCOPE_ATTRIBUTE_PREFIX_INTERNAL);
    }

    static {
        s_aRequestScope = new ThreadLocal();
        s_aInstance = new ScopeManager();
    }
}

