/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.tree.sort;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.hierarchy.visit.ChildrenProviderHierarchyVisitor;
import com.helger.commons.hierarchy.visit.DefaultHierarchyVisitorCallback;
import com.helger.commons.hierarchy.visit.EHierarchyVisitorReturn;
import com.helger.commons.tree.IBasicTree;
import com.helger.commons.tree.ITreeItem;
import com.helger.commons.tree.sort.ComparatorTreeItemData;
import com.helger.commons.tree.sort.ComparatorTreeItemDataComparable;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TreeSorter {
    private static final TreeSorter s_aInstance = new TreeSorter();

    private TreeSorter() {
    }

    private static <DATATYPE, ITEMTYPE extends ITreeItem<DATATYPE, ITEMTYPE>> void _sort(@Nonnull IBasicTree<? extends DATATYPE, ITEMTYPE> iBasicTree, final @Nonnull Comparator<? super ITEMTYPE> comparator) {
        ValueEnforcer.notNull(iBasicTree, "Tree");
        ValueEnforcer.notNull(comparator, "Comparator");
        ChildrenProviderHierarchyVisitor.visitFrom(iBasicTree.getRootItem(), new DefaultHierarchyVisitorCallback<ITEMTYPE>(){

            @Override
            @Nonnull
            public EHierarchyVisitorReturn onItemBeforeChildren(@Nullable ITEMTYPE ITEMTYPE) {
                if (ITEMTYPE != null) {
                    ITEMTYPE.reorderChildItems(comparator);
                }
                return EHierarchyVisitorReturn.CONTINUE;
            }
        }, true);
    }

    public static <DATATYPE, ITEMTYPE extends ITreeItem<DATATYPE, ITEMTYPE>> void sort(@Nonnull IBasicTree<? extends DATATYPE, ITEMTYPE> iBasicTree, @Nonnull Comparator<? super DATATYPE> comparator) {
        ComparatorTreeItemData comparatorTreeItemData = new ComparatorTreeItemData(comparator);
        TreeSorter._sort(iBasicTree, comparatorTreeItemData);
    }

    public static <DATATYPE extends Comparable<? super DATATYPE>, ITEMTYPE extends ITreeItem<DATATYPE, ITEMTYPE>> void sort(@Nonnull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree) {
        ComparatorTreeItemDataComparable comparatorTreeItemDataComparable = new ComparatorTreeItemDataComparable();
        TreeSorter._sort(iBasicTree, comparatorTreeItemDataComparable);
    }
}

