/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.xml.ls;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.string.ToStringGenerator;
import java.io.InputStream;
import java.io.Reader;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.w3c.dom.ls.LSInput;

public class ResourceLSInput
implements LSInput {
    private final IHasInputStream m_aISP;
    private String m_sEncoding;
    private String m_sPublicId;
    private String m_sSystemId;
    private boolean m_bCertifiedText;
    private String m_sBaseURI;
    private String m_sStringData;

    public ResourceLSInput(@Nonnull IReadableResource iReadableResource) {
        this(iReadableResource, iReadableResource.getResourceID());
    }

    public ResourceLSInput(@Nonnull IHasInputStream iHasInputStream, @Nullable String string) {
        this.m_aISP = ValueEnforcer.notNull(iHasInputStream, "InputStreamProvider");
        this.m_sSystemId = string;
    }

    @Override
    @Nullable
    public String getBaseURI() {
        return this.m_sBaseURI;
    }

    @Override
    public void setBaseURI(@Nullable String string) {
        this.m_sBaseURI = string;
    }

    @Override
    @Nonnull
    public InputStream getByteStream() {
        return this.m_aISP.getInputStream();
    }

    @Override
    public void setByteStream(InputStream inputStream) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getCertifiedText() {
        return this.m_bCertifiedText;
    }

    @Override
    public void setCertifiedText(boolean bl) {
        this.m_bCertifiedText = bl;
    }

    @Override
    @Nullable
    public Reader getCharacterStream() {
        return null;
    }

    @Override
    public void setCharacterStream(Reader reader) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public String getEncoding() {
        return this.m_sEncoding;
    }

    @Override
    public void setEncoding(@Nullable String string) {
        this.m_sEncoding = string;
    }

    @Override
    @Nullable
    public String getPublicId() {
        return this.m_sPublicId;
    }

    @Override
    public void setPublicId(@Nullable String string) {
        this.m_sPublicId = string;
    }

    @Override
    @Nullable
    public String getStringData() {
        return this.m_sStringData;
    }

    @Override
    public void setStringData(@Nullable String string) {
        this.m_sStringData = string;
    }

    @Override
    @Nullable
    public String getSystemId() {
        return this.m_sSystemId;
    }

    @Override
    public void setSystemId(@Nullable String string) {
        this.m_sSystemId = string;
    }

    public String toString() {
        return new ToStringGenerator(this).append("ISP", this.m_aISP).appendIfNotNull("encoding", this.m_sEncoding).appendIfNotNull("publicId", this.m_sPublicId).appendIfNotNull("systemId", this.m_sSystemId).append("certifiedText", this.m_bCertifiedText).appendIfNotNull("baseURI", this.m_sBaseURI).appendIfNotNull("stringData", this.m_sStringData).toString();
    }
}

