/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.xml.serialize.write;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.charset.CCharset;
import com.helger.commons.charset.CharsetManager;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.system.ENewLineMode;
import com.helger.commons.xml.EXMLVersion;
import com.helger.commons.xml.namespace.MapBasedNamespaceContext;
import com.helger.commons.xml.serialize.write.EXMLIncorrectCharacterHandling;
import com.helger.commons.xml.serialize.write.EXMLSerializeComments;
import com.helger.commons.xml.serialize.write.EXMLSerializeDocType;
import com.helger.commons.xml.serialize.write.EXMLSerializeIndent;
import com.helger.commons.xml.serialize.write.EXMLSerializeVersion;
import com.helger.commons.xml.serialize.write.EXMLSerializeXMLDeclaration;
import com.helger.commons.xml.serialize.write.IXMLBracketModeDeterminator;
import com.helger.commons.xml.serialize.write.IXMLIndentDeterminator;
import com.helger.commons.xml.serialize.write.IXMLWriterSettings;
import com.helger.commons.xml.serialize.write.XMLBracketModeDeterminatorHTML4;
import com.helger.commons.xml.serialize.write.XMLBracketModeDeterminatorHTML5;
import com.helger.commons.xml.serialize.write.XMLBracketModeDeterminatorXML;
import com.helger.commons.xml.serialize.write.XMLIndentDeterminatorHTML;
import com.helger.commons.xml.serialize.write.XMLIndentDeterminatorXML;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.namespace.NamespaceContext;

@NotThreadSafe
public class XMLWriterSettings
implements IXMLWriterSettings,
ICloneable<XMLWriterSettings> {
    public static final String DEFAULT_XML_CHARSET = "UTF-8";
    public static final Charset DEFAULT_XML_CHARSET_OBJ = CCharset.CHARSET_UTF_8_OBJ;
    public static final boolean DEFAULT_USE_DOUBLE_QUOTES_FOR_ATTRIBUTES = true;
    public static final boolean DEFAULT_SPACE_ON_SELF_CLOSED_ELEMENT = true;
    public static final String DEFAULT_INDENTATION_STRING = "  ";
    public static final boolean DEFAULT_EMIT_NAMESPACES = true;
    public static final boolean DEFAULT_PUT_NAMESPACE_CONTEXT_PREFIXES_IN_ROOT = false;
    public static final IXMLWriterSettings DEFAULT_XML_SETTINGS = new XMLWriterSettings();
    private EXMLVersion m_eXMLVersion = EXMLVersion.XML_10;
    private EXMLSerializeVersion m_eSerializeVersion = EXMLSerializeVersion.XML_10;
    private EXMLSerializeXMLDeclaration m_eSerializeXMLDecl = EXMLSerializeXMLDeclaration.EMIT;
    private EXMLSerializeDocType m_eSerializeDocType = EXMLSerializeDocType.EMIT;
    private EXMLSerializeComments m_eSerializeComments = EXMLSerializeComments.EMIT;
    private EXMLSerializeIndent m_eIndent = EXMLSerializeIndent.INDENT_AND_ALIGN;
    private IXMLIndentDeterminator m_aIndentDeterminator = new XMLIndentDeterminatorXML();
    private EXMLIncorrectCharacterHandling m_eIncorrectCharacterHandling = EXMLIncorrectCharacterHandling.DO_NOT_WRITE_LOG_WARNING;
    private Charset m_aCharset = DEFAULT_XML_CHARSET_OBJ;
    private NamespaceContext m_aNamespaceContext = new MapBasedNamespaceContext();
    private boolean m_bUseDoubleQuotesForAttributes = true;
    private IXMLBracketModeDeterminator m_aBracketModeDeterminator = new XMLBracketModeDeterminatorXML();
    private boolean m_bSpaceOnSelfClosedElement = true;
    private ENewLineMode m_eNewLineMode = ENewLineMode.DEFAULT;
    private String m_sIndentationString = "  ";
    private boolean m_bEmitNamespaces = true;
    private boolean m_bPutNamespaceContextPrefixesInRoot = false;
    private String m_sIndentationStringToString;

    public XMLWriterSettings() {
    }

    public XMLWriterSettings(@Nonnull IXMLWriterSettings iXMLWriterSettings) {
        ValueEnforcer.notNull(iXMLWriterSettings, "Other");
        this.setSerializeVersion(iXMLWriterSettings.getSerializeVersion());
        this.setSerializeXMLDeclaration(iXMLWriterSettings.getSerializeXMLDeclaration());
        this.setSerializeDocType(iXMLWriterSettings.getSerializeDocType());
        this.setSerializeComments(iXMLWriterSettings.getSerializeComments());
        this.setIndent(iXMLWriterSettings.getIndent());
        this.setIndentDeterminator(iXMLWriterSettings.getIndentDeterminator());
        this.setIncorrectCharacterHandling(iXMLWriterSettings.getIncorrectCharacterHandling());
        this.setCharset(iXMLWriterSettings.getCharsetObj());
        this.setNamespaceContext(iXMLWriterSettings.getNamespaceContext());
        this.setBracketModeDeterminator(iXMLWriterSettings.getBracketModeDeterminator());
        this.setUseDoubleQuotesForAttributes(iXMLWriterSettings.isUseDoubleQuotesForAttributes());
        this.setSpaceOnSelfClosedElement(iXMLWriterSettings.isSpaceOnSelfClosedElement());
        this.setNewLineMode(iXMLWriterSettings.getNewLineMode());
        this.setIndentationString(iXMLWriterSettings.getIndentationString());
        this.setEmitNamespaces(iXMLWriterSettings.isEmitNamespaces());
        this.setPutNamespaceContextPrefixesInRoot(iXMLWriterSettings.isPutNamespaceContextPrefixesInRoot());
    }

    @Override
    @Nonnull
    public EXMLVersion getXMLVersion() {
        return this.m_eXMLVersion;
    }

    @Nonnull
    public final XMLWriterSettings setSerializeVersion(@Nonnull EXMLSerializeVersion eXMLSerializeVersion) {
        this.m_eSerializeVersion = ValueEnforcer.notNull(eXMLSerializeVersion, "Version");
        this.m_eXMLVersion = eXMLSerializeVersion.getXMLVersionOrDefault(EXMLVersion.XML_10);
        return this;
    }

    @Override
    @Nonnull
    public EXMLSerializeVersion getSerializeVersion() {
        return this.m_eSerializeVersion;
    }

    @Nonnull
    public final XMLWriterSettings setSerializeXMLDeclaration(@Nonnull EXMLSerializeXMLDeclaration eXMLSerializeXMLDeclaration) {
        this.m_eSerializeXMLDecl = ValueEnforcer.notNull(eXMLSerializeXMLDeclaration, "SerializeXMLDecl");
        return this;
    }

    @Override
    @Nonnull
    public EXMLSerializeXMLDeclaration getSerializeXMLDeclaration() {
        return this.m_eSerializeXMLDecl;
    }

    @Nonnull
    public final XMLWriterSettings setSerializeDocType(@Nonnull EXMLSerializeDocType eXMLSerializeDocType) {
        this.m_eSerializeDocType = ValueEnforcer.notNull(eXMLSerializeDocType, "SerializeDocType");
        return this;
    }

    @Override
    @Nonnull
    public EXMLSerializeDocType getSerializeDocType() {
        return this.m_eSerializeDocType;
    }

    @Nonnull
    public final XMLWriterSettings setSerializeComments(@Nonnull EXMLSerializeComments eXMLSerializeComments) {
        this.m_eSerializeComments = ValueEnforcer.notNull(eXMLSerializeComments, "SerializeComments");
        return this;
    }

    @Override
    @Nonnull
    public EXMLSerializeComments getSerializeComments() {
        return this.m_eSerializeComments;
    }

    @Nonnull
    public final XMLWriterSettings setIndent(@Nonnull EXMLSerializeIndent eXMLSerializeIndent) {
        this.m_eIndent = ValueEnforcer.notNull(eXMLSerializeIndent, "Indent");
        return this;
    }

    @Override
    @Nonnull
    public EXMLSerializeIndent getIndent() {
        return this.m_eIndent;
    }

    @Nonnull
    public final XMLWriterSettings setIndentDeterminator(@Nonnull IXMLIndentDeterminator iXMLIndentDeterminator) {
        this.m_aIndentDeterminator = ValueEnforcer.notNull(iXMLIndentDeterminator, "IndentDeterminator");
        return this;
    }

    @Override
    @Nonnull
    public IXMLIndentDeterminator getIndentDeterminator() {
        return this.m_aIndentDeterminator;
    }

    @Nonnull
    public final XMLWriterSettings setIncorrectCharacterHandling(@Nonnull EXMLIncorrectCharacterHandling eXMLIncorrectCharacterHandling) {
        this.m_eIncorrectCharacterHandling = ValueEnforcer.notNull(eXMLIncorrectCharacterHandling, "IncorrectCharacterHandling");
        return this;
    }

    @Override
    @Nonnull
    public EXMLIncorrectCharacterHandling getIncorrectCharacterHandling() {
        return this.m_eIncorrectCharacterHandling;
    }

    @Nonnull
    public final XMLWriterSettings setCharset(@Nonnull Charset charset) {
        this.m_aCharset = ValueEnforcer.notNull(charset, "Charset");
        return this;
    }

    @Override
    @Nonnull
    public String getCharset() {
        return this.m_aCharset.name();
    }

    @Override
    @Nonnull
    public Charset getCharsetObj() {
        return this.m_aCharset;
    }

    @Nonnull
    public final XMLWriterSettings setNamespaceContext(@Nullable NamespaceContext namespaceContext) {
        this.m_aNamespaceContext = namespaceContext != null ? namespaceContext : new MapBasedNamespaceContext();
        return this;
    }

    @Override
    @Nonnull
    public NamespaceContext getNamespaceContext() {
        return this.m_aNamespaceContext;
    }

    @Nonnull
    public final XMLWriterSettings setUseDoubleQuotesForAttributes(boolean bl) {
        this.m_bUseDoubleQuotesForAttributes = bl;
        return this;
    }

    @Override
    public boolean isUseDoubleQuotesForAttributes() {
        return this.m_bUseDoubleQuotesForAttributes;
    }

    @Nonnull
    public final XMLWriterSettings setBracketModeDeterminator(@Nonnull IXMLBracketModeDeterminator iXMLBracketModeDeterminator) {
        ValueEnforcer.notNull(iXMLBracketModeDeterminator, "BracketModeDeterminator");
        this.m_aBracketModeDeterminator = iXMLBracketModeDeterminator;
        return this;
    }

    @Override
    @Nonnull
    public IXMLBracketModeDeterminator getBracketModeDeterminator() {
        return this.m_aBracketModeDeterminator;
    }

    @Nonnull
    public final XMLWriterSettings setSpaceOnSelfClosedElement(boolean bl) {
        this.m_bSpaceOnSelfClosedElement = bl;
        return this;
    }

    @Override
    public boolean isSpaceOnSelfClosedElement() {
        return this.m_bSpaceOnSelfClosedElement;
    }

    @Nonnull
    public final XMLWriterSettings setNewLineMode(@Nonnull ENewLineMode eNewLineMode) {
        this.m_eNewLineMode = ValueEnforcer.notNull(eNewLineMode, "NewLineMode");
        return this;
    }

    @Override
    @Nonnull
    public ENewLineMode getNewLineMode() {
        return this.m_eNewLineMode;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getNewLineString() {
        return this.m_eNewLineMode.getText();
    }

    @Nonnull
    public final XMLWriterSettings setIndentationString(@Nonnull @Nonempty String string) {
        this.m_sIndentationString = ValueEnforcer.notEmpty(string, "IndentationString");
        this.m_sIndentationStringToString = null;
        return this;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getIndentationString() {
        return this.m_sIndentationString;
    }

    @Nonnull
    public final XMLWriterSettings setEmitNamespaces(boolean bl) {
        this.m_bEmitNamespaces = bl;
        return this;
    }

    @Override
    public boolean isEmitNamespaces() {
        return this.m_bEmitNamespaces;
    }

    @Nonnull
    public final XMLWriterSettings setPutNamespaceContextPrefixesInRoot(boolean bl) {
        this.m_bPutNamespaceContextPrefixesInRoot = bl;
        return this;
    }

    @Override
    public boolean isPutNamespaceContextPrefixesInRoot() {
        return this.m_bPutNamespaceContextPrefixesInRoot;
    }

    @Override
    @Nonnull
    public XMLWriterSettings getClone() {
        return new XMLWriterSettings(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        XMLWriterSettings xMLWriterSettings = (XMLWriterSettings)object;
        return this.m_eXMLVersion.equals((Object)xMLWriterSettings.m_eXMLVersion) && this.m_eSerializeXMLDecl.equals(xMLWriterSettings.m_eSerializeXMLDecl) && this.m_eSerializeDocType.equals(xMLWriterSettings.m_eSerializeDocType) && this.m_eSerializeComments.equals(xMLWriterSettings.m_eSerializeComments) && this.m_eIndent.equals(xMLWriterSettings.m_eIndent) && this.m_aIndentDeterminator.equals(xMLWriterSettings.m_aIndentDeterminator) && this.m_eIncorrectCharacterHandling.equals((Object)xMLWriterSettings.m_eIncorrectCharacterHandling) && this.m_aCharset.equals(xMLWriterSettings.m_aCharset) && EqualsHelper.equals(this.m_aNamespaceContext, xMLWriterSettings.m_aNamespaceContext) && this.m_bUseDoubleQuotesForAttributes == xMLWriterSettings.m_bUseDoubleQuotesForAttributes && this.m_aBracketModeDeterminator.equals(xMLWriterSettings.m_aBracketModeDeterminator) && this.m_bSpaceOnSelfClosedElement == xMLWriterSettings.m_bSpaceOnSelfClosedElement && this.m_eNewLineMode.equals((Object)xMLWriterSettings.m_eNewLineMode) && this.m_sIndentationString.equals(xMLWriterSettings.m_sIndentationString) && this.m_bEmitNamespaces == xMLWriterSettings.m_bEmitNamespaces && this.m_bPutNamespaceContextPrefixesInRoot == xMLWriterSettings.m_bPutNamespaceContextPrefixesInRoot;
    }

    public int hashCode() {
        return ((HashCodeGenerator)((HashCodeGenerator)((HashCodeGenerator)((HashCodeGenerator)((HashCodeGenerator)((HashCodeGenerator)((HashCodeGenerator)new HashCodeGenerator(this).append((Enum)this.m_eXMLVersion)).append((Enum)this.m_eSerializeXMLDecl)).append((Enum)this.m_eSerializeDocType)).append((Enum)this.m_eSerializeComments)).append((Enum)this.m_eIndent)).append(this.m_aIndentDeterminator).append((Enum)this.m_eIncorrectCharacterHandling)).append(this.m_aCharset).append(this.m_aNamespaceContext).append(this.m_bUseDoubleQuotesForAttributes).append(this.m_aBracketModeDeterminator).append(this.m_bSpaceOnSelfClosedElement).append((Enum)this.m_eNewLineMode)).append(this.m_sIndentationString).append(this.m_bEmitNamespaces).append(this.m_bPutNamespaceContextPrefixesInRoot).getHashCode();
    }

    public String toString() {
        if (this.m_sIndentationStringToString == null) {
            this.m_sIndentationStringToString = StringHelper.getHexEncoded(CharsetManager.getAsBytes(this.m_sIndentationString, CCharset.CHARSET_ISO_8859_1_OBJ));
        }
        return new ToStringGenerator(this).append("xmlVersion", this.m_eXMLVersion).append("serializeXMLDecl", this.m_eSerializeXMLDecl).append("serializeDocType", this.m_eSerializeDocType).append("serializeComments", this.m_eSerializeComments).append("indent", this.m_eIndent).append("indentDeterminator", this.m_aIndentDeterminator).append("incorrectCharHandling", this.m_eIncorrectCharacterHandling).append("charset", this.m_aCharset).append("namespaceContext", this.m_aNamespaceContext).append("doubleQuotesForAttrs", this.m_bUseDoubleQuotesForAttributes).append("bracketModeDeterminator", this.m_aBracketModeDeterminator).append("spaceOnSelfClosedElement", this.m_bSpaceOnSelfClosedElement).append("newlineMode", this.m_eNewLineMode).append("indentationString", this.m_sIndentationStringToString).append("emitNamespaces", this.m_bEmitNamespaces).append("putNamespaceContextPrefixesInRoot", this.m_bPutNamespaceContextPrefixesInRoot).toString();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static XMLWriterSettings createForHTML4() {
        return new XMLWriterSettings().setSerializeVersion(EXMLSerializeVersion.HTML).setSerializeXMLDeclaration(EXMLSerializeXMLDeclaration.IGNORE).setIndentDeterminator(new XMLIndentDeterminatorHTML()).setBracketModeDeterminator(new XMLBracketModeDeterminatorHTML4()).setSpaceOnSelfClosedElement(true).setPutNamespaceContextPrefixesInRoot(true);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static XMLWriterSettings createForXHTML() {
        return new XMLWriterSettings().setSerializeVersion(EXMLSerializeVersion.HTML).setSerializeXMLDeclaration(EXMLSerializeXMLDeclaration.IGNORE).setIndentDeterminator(new XMLIndentDeterminatorHTML()).setBracketModeDeterminator(new XMLBracketModeDeterminatorHTML4()).setSpaceOnSelfClosedElement(true).setPutNamespaceContextPrefixesInRoot(true);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static XMLWriterSettings createForHTML5() {
        return new XMLWriterSettings().setSerializeVersion(EXMLSerializeVersion.HTML).setSerializeXMLDeclaration(EXMLSerializeXMLDeclaration.IGNORE).setIndentDeterminator(new XMLIndentDeterminatorHTML()).setBracketModeDeterminator(new XMLBracketModeDeterminatorHTML5()).setSpaceOnSelfClosedElement(true).setPutNamespaceContextPrefixesInRoot(true);
    }
}

