/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.concurrent;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.ToStringGenerator;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ExtendedDefaultThreadFactory
implements ThreadFactory {
    private static final AtomicInteger s_aPoolNumber = new AtomicInteger(1);
    private final ThreadGroup m_aThreadGroup;
    private final AtomicInteger m_aThreadNumber = new AtomicInteger(1);
    private final String m_sNamePrefix;

    public ExtendedDefaultThreadFactory() {
        this("threadpool");
    }

    public ExtendedDefaultThreadFactory(@Nonnull @Nonempty String string) {
        SecurityManager securityManager = System.getSecurityManager();
        this.m_aThreadGroup = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.m_sNamePrefix = string + "[p" + s_aPoolNumber.getAndIncrement() + "-t";
    }

    @Override
    @Nonnull
    public Thread newThread(@Nonnull Runnable runnable) {
        String string = this.m_sNamePrefix + this.m_aThreadNumber.getAndIncrement() + ']';
        Thread thread = new Thread(this.m_aThreadGroup, runnable, string, 0L);
        if (thread.isDaemon()) {
            thread.setDaemon(false);
        }
        if (thread.getPriority() != 5) {
            thread.setPriority(5);
        }
        return thread;
    }

    public String toString() {
        return new ToStringGenerator(this).append("threadGroup", this.m_aThreadGroup).append("threadNumber", this.m_aThreadNumber).append("namePrefix", this.m_sNamePrefix).toString();
    }
}

