/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.state;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.id.IHasID;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.state.ITriState;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum ETriState implements IHasID<String>,
ITriState
{
    TRUE("true", Boolean.TRUE),
    FALSE("false", Boolean.FALSE),
    UNDEFINED("undefined", null);

    private final String m_sID;
    private final Boolean m_aBoolean;

    private ETriState(String string2, Boolean bl) {
        this.m_sID = string2;
        this.m_aBoolean = bl;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Override
    public boolean isTrue() {
        return this == TRUE;
    }

    @Override
    public boolean isFalse() {
        return this == FALSE;
    }

    @Override
    public boolean isDefined() {
        return this != UNDEFINED;
    }

    @Override
    public boolean isUndefined() {
        return this == UNDEFINED;
    }

    @Override
    public boolean getAsBooleanValue(boolean bl) {
        return this == UNDEFINED ? bl : this.m_aBoolean;
    }

    @Nullable
    public Boolean getAsBooleanObj(boolean bl) {
        return this.getAsBooleanObj((Boolean)bl);
    }

    @Override
    @Nullable
    public Boolean getAsBooleanObj(@Nullable Boolean bl) {
        return this == UNDEFINED ? bl : this.m_aBoolean;
    }

    @Nonnull
    public static ETriState valueOf(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    @Nonnull
    public static ETriState valueOf(@Nullable Boolean bl) {
        return bl == null ? UNDEFINED : ETriState.valueOf((boolean)bl);
    }

    @Nonnull
    public static ETriState valueOf(@Nonnull ITriState iTriState) {
        return ETriState.valueOf(iTriState.getAsBooleanObj(null));
    }

    @Nullable
    public static ETriState getFromIDOrNull(@Nullable String string) {
        return EnumHelper.getFromIDOrNull(ETriState.class, string);
    }

    @Nonnull
    public static ETriState getFromIDOrUndefined(@Nullable String string) {
        return ETriState.getFromIDOrDefault(string, UNDEFINED);
    }

    @Nullable
    public static ETriState getFromIDOrDefault(@Nullable String string, @Nullable ETriState eTriState) {
        return EnumHelper.getFromIDOrDefault(ETriState.class, string, eTriState);
    }
}

