/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.url;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.callback.INonThrowingRunnableWithParameter;
import com.helger.commons.charset.CCharset;
import com.helger.commons.codec.IDecoder;
import com.helger.commons.codec.IEncoder;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.exception.InitializationException;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.lang.ClassLoaderHelper;
import com.helger.commons.microdom.util.XMLMapHandler;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.string.StringHelper;
import com.helger.commons.url.IURLData;
import com.helger.commons.url.IURLProtocol;
import com.helger.commons.url.URLData;
import com.helger.commons.url.URLParameterEncoder;
import com.helger.commons.url.URLProtocolRegistry;
import com.helger.commons.wrapper.IMutableWrapper;
import com.helger.commons.wrapper.Wrapper;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class URLHelper {
    public static final String CHARSET_URL = "UTF-8";
    public static final Charset CHARSET_URL_OBJ = CCharset.CHARSET_UTF_8_OBJ;
    public static final char QUESTIONMARK = '?';
    public static final String QUESTIONMARK_STR = Character.toString('?');
    public static final char AMPERSAND = '&';
    public static final String AMPERSAND_STR = Character.toString('&');
    public static final char EQUALS = '=';
    public static final String EQUALS_STR = Character.toString('=');
    public static final char HASH = '#';
    public static final String HASH_STR = Character.toString('#');
    public static final String PROTOCOL_FILE = "file";
    private static final Logger s_aLogger = LoggerFactory.getLogger(URLHelper.class);
    private static char[] s_aCleanURLOld;
    private static char[][] s_aCleanURLNew;
    private static final URLHelper s_aInstance;

    private URLHelper() {
    }

    @Nonnull
    public static String urlDecode(@Nonnull String string) {
        return URLHelper.urlDecode(string, CHARSET_URL);
    }

    @Nonnull
    public static String urlDecode(@Nonnull String string, @Nonnull Charset charset) {
        ValueEnforcer.notNull(charset, "Charset");
        return URLHelper.urlDecode(string, charset.name());
    }

    @Nonnull
    public static String urlDecode(@Nonnull String string, @Nonnull @Nonempty String string2) {
        try {
            return URLDecoder.decode(string, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return URLDecoder.decode(string);
        }
    }

    @Nonnull
    public static String urlEncode(@Nonnull String string) {
        return URLHelper.urlEncode(string, CHARSET_URL);
    }

    @Nonnull
    public static String urlEncode(@Nonnull String string, @Nonnull Charset charset) {
        ValueEnforcer.notNull(charset, "Charset");
        return URLHelper.urlEncode(string, charset.name());
    }

    @Nonnull
    public static String urlEncode(@Nonnull String string, @Nonnull @Nonempty String string2) {
        try {
            return URLEncoder.encode(string, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return URLEncoder.encode(string);
        }
    }

    private static void _initCleanURL() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (XMLMapHandler.readMap(new ClassPathResource("codelists/cleanurl-data.xml"), hashMap).isFailure()) {
            throw new InitializationException("Failed to init CleanURL data!");
        }
        s_aCleanURLOld = new char[hashMap.size()];
        s_aCleanURLNew = new char[hashMap.size()][];
        int n = 0;
        for (Map.Entry entry : hashMap.entrySet()) {
            String string = (String)entry.getKey();
            if (string.length() != 1) {
                throw new IllegalStateException("Clean URL source character has an invalid length: " + string.length());
            }
            URLHelper.s_aCleanURLOld[n] = string.charAt(0);
            URLHelper.s_aCleanURLNew[n] = ((String)entry.getValue()).toCharArray();
            ++n;
        }
    }

    @Nullable
    public static String getCleanURLPartWithoutUmlauts(@Nullable String string) {
        if (s_aCleanURLOld == null) {
            URLHelper._initCleanURL();
        }
        char[] cArray = StringHelper.replaceMultiple(string, s_aCleanURLOld, s_aCleanURLNew);
        return new String(cArray);
    }

    @Nonnull
    public static IURLData getAsURLData(@Nonnull String string) {
        return URLHelper.getAsURLData(string, null);
    }

    @Nonnull
    public static IURLData getAsURLData(@Nonnull String string, @Nullable IDecoder<String> iDecoder) {
        String string2;
        String string3;
        ValueEnforcer.notNull(string, "Href");
        String string4 = string.trim();
        IURLProtocol iURLProtocol = URLProtocolRegistry.getInstance().getProtocol(string4);
        if (iURLProtocol != null && !iURLProtocol.allowsForQueryParameters()) {
            return new URLData(string4, null, null);
        }
        if (GlobalDebug.isDebugMode() && iURLProtocol != null) {
            try {
                new URL(string4);
            }
            catch (MalformedURLException malformedURLException) {
                s_aLogger.warn("java.net.URL claims URL '" + string4 + "' to be invalid: " + malformedURLException.getMessage());
            }
        }
        Map<String, String> map = null;
        String string5 = string4;
        int n = string5.indexOf(35);
        if (n >= 0) {
            string3 = string5.substring(n + 1).trim();
            string5 = string5.substring(0, n).trim();
        } else {
            string3 = null;
        }
        int n2 = string5.indexOf(63);
        if (n2 >= 0) {
            String string6 = string5.substring(n2 + 1).trim();
            if (StringHelper.hasText(string6)) {
                map = URLHelper._getQueryStringAsMap(string6, iDecoder);
            }
            string2 = string5.substring(0, n2).trim();
        } else {
            string2 = string5;
        }
        return new URLData(string2, map, string3);
    }

    @Nonnull
    @ReturnsMutableCopy
    private static Map<String, String> _getQueryStringAsMap(@Nullable String string, @Nullable IDecoder<String> iDecoder) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        if (StringHelper.hasText(string)) {
            for (String string2 : StringHelper.getExploded('&', string)) {
                String string3;
                List<String> list;
                String string4;
                if (string2.length() <= 0 || !StringHelper.hasText(string4 = (list = StringHelper.getExploded('=', string2, 2)).get(0))) continue;
                String string5 = string3 = list.size() == 2 ? list.get(1) : "";
                if (string3 == null) {
                    throw new NullPointerException("parameter value may not be null");
                }
                if (iDecoder != null) {
                    linkedHashMap.put(iDecoder.getDecoded(string4), iDecoder.getDecoded(string3));
                    continue;
                }
                linkedHashMap.put(string4, string3);
            }
        }
        return linkedHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Map<String, String> getQueryStringAsMap(@Nullable String string) {
        return URLHelper._getQueryStringAsMap(string, null);
    }

    @Nonnull
    public static String getURLString(@Nonnull IURLData iURLData, @Nullable Charset charset) {
        return URLHelper.getURLString(iURLData.getPath(), iURLData.getAllParams(), iURLData.getAnchor(), charset);
    }

    @Nullable
    public static String getURLString(@Nullable String string, @Nullable Map<String, String> map, @Nullable String string2, @Nullable IEncoder<String> iEncoder) {
        boolean bl = CollectionHelper.isNotEmpty(map);
        boolean bl2 = StringHelper.hasText(string2);
        if (!bl && !bl2) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (StringHelper.hasText(string)) {
            stringBuilder.append(string);
        }
        if (bl) {
            boolean bl3;
            boolean bl4 = bl3 = stringBuilder.indexOf(QUESTIONMARK_STR) >= 0;
            if (bl3) {
                char c = StringHelper.getLastChar(stringBuilder);
                if (c != '?' && c != '&') {
                    stringBuilder.append('&');
                }
            } else {
                stringBuilder.append('?');
            }
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String string3 = entry.getKey();
                if (iEncoder != null) {
                    stringBuilder.append(iEncoder.getEncoded(string3));
                } else {
                    stringBuilder.append(string3);
                }
                String string4 = entry.getValue();
                if (StringHelper.hasText(string4)) {
                    if (iEncoder != null) {
                        stringBuilder.append('=').append(iEncoder.getEncoded(string4));
                    } else {
                        stringBuilder.append('=').append(string4);
                    }
                }
                stringBuilder.append('&');
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        if (bl2) {
            if (StringHelper.getLastChar(stringBuilder) != '#') {
                stringBuilder.append('#');
            }
            stringBuilder.append(string2);
        }
        if (stringBuilder.length() == 0) {
            return QUESTIONMARK_STR;
        }
        return stringBuilder.toString();
    }

    @Nullable
    public static String getURLString(@Nullable String string, @Nullable Map<String, String> map, @Nullable String string2, @Nullable Charset charset) {
        URLParameterEncoder uRLParameterEncoder = charset == null ? null : new URLParameterEncoder(charset);
        return URLHelper.getURLString(string, map, string2, uRLParameterEncoder);
    }

    @Nullable
    public static URL getAsURL(@Nullable String string) {
        if (StringHelper.hasText(string)) {
            try {
                return new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static URL getAsURL(@Nullable URI uRI) {
        if (uRI != null) {
            try {
                return uRI.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static URI getAsURI(@Nullable String string) {
        if (StringHelper.hasText(string)) {
            try {
                return new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static URI getAsURI(@Nullable URL uRL) {
        if (uRL != null) {
            try {
                return uRL.toURI();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static InputStream getInputStream(@Nonnull URL uRL, @CheckForSigned int n, @CheckForSigned int n2, @Nullable INonThrowingRunnableWithParameter<URLConnection> iNonThrowingRunnableWithParameter, @Nullable IMutableWrapper<IOException> iMutableWrapper) {
        ValueEnforcer.notNull(uRL, "URL");
        HttpURLConnection httpURLConnection = null;
        try {
            Object object;
            URLConnection uRLConnection = uRL.openConnection();
            if (n >= 0) {
                uRLConnection.setConnectTimeout(n);
            }
            if (n2 >= 0) {
                uRLConnection.setReadTimeout(n2);
            }
            if (uRLConnection instanceof HttpURLConnection) {
                httpURLConnection = (HttpURLConnection)uRLConnection;
            }
            uRLConnection.setUseCaches(false);
            if (iNonThrowingRunnableWithParameter != null) {
                iNonThrowingRunnableWithParameter.run(uRLConnection);
            }
            if (uRLConnection instanceof JarURLConnection && (object = ((JarURLConnection)uRLConnection).getJarEntry()) != null) {
                if (((ZipEntry)object).isDirectory()) {
                    return null;
                }
                if (((ZipEntry)object).getSize() == 0L && ((ZipEntry)object).getCrc() == 0L) {
                    s_aLogger.warn("Heuristically determined " + uRL + " to be a directory!");
                    return null;
                }
            }
            object = uRLConnection.getInputStream();
            return object;
        }
        catch (IOException iOException) {
            if (iMutableWrapper != null) {
                iMutableWrapper.set(iOException);
            } else if (iOException instanceof SocketTimeoutException) {
                s_aLogger.warn("Timeout to open input stream for '" + uRL + "': " + iOException.getClass().getName() + " - " + iOException.getMessage());
            } else {
                s_aLogger.warn("Failed to open input stream for '" + uRL + "': " + iOException.getClass().getName() + " - " + iOException.getMessage());
            }
            if (httpURLConnection != null) {
                InputStream inputStream = null;
                try {
                    inputStream = httpURLConnection.getErrorStream();
                    if (inputStream != null) {
                        byte[] byArray = new byte[1024];
                        while (inputStream.read(byArray) > 0) {
                        }
                    }
                }
                catch (IOException iOException2) {
                    s_aLogger.warn("Failed to consume error stream for '" + uRL + "': " + iOException2.getClass().getName() + " - " + iOException2.getMessage());
                }
                finally {
                    StreamHelper.close(inputStream);
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @Deprecated
    public static InputStream postAndGetInputStream(final @Nonnull URL uRL, int n, int n2, final @Nullable IMimeType iMimeType, final @Nonnull byte[] byArray, final @Nullable Map<String, String> map, final @Nullable INonThrowingRunnableWithParameter<URLConnection> iNonThrowingRunnableWithParameter, @Nullable IMutableWrapper<IOException> iMutableWrapper) {
        ValueEnforcer.notNull(uRL, "URL");
        ValueEnforcer.notNull(byArray, "ContentBytes");
        final Wrapper wrapper = new Wrapper();
        INonThrowingRunnableWithParameter<URLConnection> iNonThrowingRunnableWithParameter2 = new INonThrowingRunnableWithParameter<URLConnection>(){

            @Override
            public void run(@Nonnull URLConnection uRLConnection) {
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                try {
                    httpURLConnection.setRequestMethod("POST");
                    httpURLConnection.setDoInput(true);
                    httpURLConnection.setDoOutput(true);
                    if (iMimeType != null) {
                        httpURLConnection.setRequestProperty("Content-Type", iMimeType.getAsString());
                    }
                    httpURLConnection.setRequestProperty("Content-Length", Integer.toString(byArray.length));
                    if (map != null) {
                        for (Map.Entry entry : map.entrySet()) {
                            httpURLConnection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
                        }
                    }
                    OutputStream outputStream = httpURLConnection.getOutputStream();
                    wrapper.set(outputStream);
                    outputStream.write(byArray);
                    outputStream.flush();
                }
                catch (IOException iOException) {
                    throw new IllegalStateException("Failed to POST data to " + uRL.toExternalForm(), iOException);
                }
                if (iNonThrowingRunnableWithParameter != null) {
                    iNonThrowingRunnableWithParameter.run(uRLConnection);
                }
            }
        };
        try {
            InputStream inputStream = URLHelper.getInputStream(uRL, n, n2, iNonThrowingRunnableWithParameter2, iMutableWrapper);
            return inputStream;
        }
        finally {
            StreamHelper.close((Closeable)wrapper.get());
        }
    }

    @Nonnull
    public static String getApplicationFormEncoded(@Nullable Map<String, String> map, @Nullable IEncoder<String> iEncoder) {
        if (CollectionHelper.isEmpty(map)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String string;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('&');
                }
                String string2 = entry.getKey();
                if (iEncoder != null) {
                    stringBuilder.append(iEncoder.getEncoded(string2));
                } else {
                    stringBuilder.append(string2);
                }
                if (!StringHelper.hasText(string = entry.getValue())) continue;
                if (iEncoder != null) {
                    stringBuilder.append('=').append(iEncoder.getEncoded(string));
                    continue;
                }
                stringBuilder.append('=').append(string);
            }
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public static File getAsFile(@Nonnull URL uRL) {
        File file;
        ValueEnforcer.notNull(uRL, "URL");
        if (!PROTOCOL_FILE.equals(uRL.getProtocol())) {
            throw new IllegalArgumentException("Not a file URL: " + uRL);
        }
        try {
            file = new File(uRL.toURI().getSchemeSpecificPart());
        }
        catch (URISyntaxException uRISyntaxException) {
            file = new File(uRL.getPath());
        }
        return file;
    }

    @Nullable
    public static File getAsFileOrNull(@Nonnull URL uRL) {
        if (uRL != null) {
            try {
                return URLHelper.getAsFile(uRL);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static URL getClassPathURL(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Path");
        String string2 = string.startsWith("/") ? string : '/' + string;
        URL uRL = ClassLoaderHelper.getDefaultClassLoader().getResource(string2);
        if (uRL == null && (uRL = ClassPathResource.class.getResource(string2)) == null) {
            uRL = ClassLoader.getSystemClassLoader().getResource(string2);
        }
        return uRL;
    }

    @Nullable
    public static URL getClassPathURL(@Nonnull @Nonempty String string, @Nonnull ClassLoader classLoader) {
        ValueEnforcer.notNull(classLoader, "ClassLoader");
        ValueEnforcer.notEmpty(string, "Path");
        String string2 = string.startsWith("/") ? string : '/' + string;
        return classLoader.getResource(string2);
    }

    public static boolean isClassPathURLExisting(@Nonnull @Nonempty String string) {
        return URLHelper.getClassPathURL(string) != null;
    }

    public static boolean isClassPathURLExisting(@Nonnull @Nonempty String string, @Nonnull ClassLoader classLoader) {
        return URLHelper.getClassPathURL(string, classLoader) != null;
    }

    static {
        s_aInstance = new URLHelper();
    }
}

