/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.jaxb;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ClassLoaderHelper;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class JAXBContextCacheKey {
    private final Package m_aPackage;
    private final ClassLoader m_aClassLoader;

    public JAXBContextCacheKey(@Nonnull Package package_, @Nullable ClassLoader classLoader) {
        this.m_aPackage = ValueEnforcer.notNull(package_, "Package");
        this.m_aClassLoader = classLoader != null ? classLoader : ClassLoaderHelper.getDefaultClassLoader();
    }

    @Nonnull
    public Package getPackage() {
        return this.m_aPackage;
    }

    @Nonnull
    public ClassLoader getClassLoader() {
        return this.m_aClassLoader;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        JAXBContextCacheKey jAXBContextCacheKey = (JAXBContextCacheKey)object;
        return this.m_aPackage.equals(jAXBContextCacheKey.m_aPackage) && this.m_aClassLoader.equals(jAXBContextCacheKey.m_aClassLoader);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aPackage).append(this.m_aClassLoader).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("Package", this.m_aPackage).append("ClassLoader", this.m_aClassLoader).toString();
    }
}

