/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.locale;

import com.helger.commons.CGlobal;
import com.helger.commons.annotation.ELockType;
import com.helger.commons.annotation.MustBeLocked;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.locale.LocaleHelper;
import com.helger.commons.string.StringHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class LocaleCache {
    private static final Logger s_aLogger = LoggerFactory.getLogger(LocaleCache.class);
    private static boolean s_bDefaultInstantiated = false;
    private final ReadWriteLock m_aRWLock = new ReentrantReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final Map<String, Locale> m_aLocales = new HashMap<String, Locale>();

    private LocaleCache() {
        this.reinitialize();
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static LocaleCache getInstance() {
        LocaleCache localeCache = SingletonHolder.s_aInstance;
        s_bDefaultInstantiated = true;
        return localeCache;
    }

    @Nullable
    public Locale getLocale(@Nullable String string) {
        if (string != null && string.length() > 2) {
            String[] stringArray = StringHelper.getExplodedArray('_', string, 3);
            if (stringArray.length == 3) {
                return this.getLocale(stringArray[0], stringArray[1], stringArray[2]);
            }
            if (stringArray.length == 2) {
                return this.getLocale(stringArray[0], stringArray[1], "");
            }
        }
        return this.getLocale(string, "", "");
    }

    @Nullable
    public Locale getLocale(@Nullable String string, @Nullable String string2) {
        return this.getLocale(string, string2, "");
    }

    @Nonnull
    private static String _buildLocaleString(@Nonnull String string, @Nonnull String string2, @Nonnull String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string.length() > 0) {
            stringBuilder.append(string);
        }
        if (string2.length() > 0) {
            stringBuilder.append('_').append(string2);
        }
        if (string3.length() > 0) {
            stringBuilder.append('_').append(string3);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Locale getLocale(@Nullable String string, @Nullable String string2, @Nullable String string3) {
        Locale locale;
        String string4;
        String string5;
        String string6 = StringHelper.getNotNull(LocaleHelper.getValidLanguageCode(string));
        String string7 = LocaleCache._buildLocaleString(string6, string5 = StringHelper.getNotNull(LocaleHelper.getValidCountryCode(string2)), string4 = StringHelper.getNotNull(string3));
        if (string7.length() == 0) {
            return null;
        }
        this.m_aRWLock.readLock().lock();
        try {
            locale = this.m_aLocales.get(string7);
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
        if (locale == null) {
            this.m_aRWLock.writeLock().lock();
            try {
                locale = this.m_aLocales.get(string7);
                if (locale == null) {
                    locale = new Locale(string6, string5, string4);
                    this.m_aLocales.put(string7, locale);
                }
            }
            finally {
                this.m_aRWLock.writeLock().unlock();
            }
        }
        return locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public Set<Locale> getAllLocales() {
        this.m_aRWLock.readLock().lock();
        try {
            Set<Locale> set = CollectionHelper.newSet(this.m_aLocales.values());
            set.remove(CGlobal.LOCALE_ALL);
            set.remove(CGlobal.LOCALE_INDEPENDENT);
            Set<Locale> set2 = set;
            return set2;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public Set<Locale> getAllLanguages() {
        HashSet<Locale> hashSet = new HashSet<Locale>();
        for (Locale locale : this.getAllLocales()) {
            String string = locale.getLanguage();
            if (!StringHelper.hasText(string)) continue;
            hashSet.add(this.getLocale(string, null, null));
        }
        return hashSet;
    }

    public boolean containsLocale(@Nullable String string) {
        if (string != null && string.length() > 2) {
            String[] stringArray = StringHelper.getExplodedArray('_', string, 3);
            if (stringArray.length == 3) {
                return this.containsLocale(stringArray[0], stringArray[1], stringArray[2]);
            }
            if (stringArray.length == 2) {
                return this.containsLocale(stringArray[0], stringArray[1], "");
            }
        }
        return this.containsLocale(string, "", "");
    }

    public boolean containsLocale(@Nullable String string, @Nullable String string2) {
        return this.containsLocale(string, string2, "");
    }

    @Nonnull
    private static String _createLocaleKey(@Nullable String string, @Nullable String string2, @Nullable String string3) {
        String string4 = StringHelper.getNotNull(LocaleHelper.getValidLanguageCode(string));
        String string5 = StringHelper.getNotNull(LocaleHelper.getValidCountryCode(string2));
        String string6 = StringHelper.getNotNull(string3);
        return LocaleCache._buildLocaleString(string4, string5, string6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsLocale(@Nullable String string, @Nullable String string2, @Nullable String string3) {
        String string4 = LocaleCache._createLocaleKey(string, string2, string3);
        if (string4.length() == 0) {
            return false;
        }
        this.m_aRWLock.readLock().lock();
        try {
            boolean bl = this.m_aLocales.containsKey(string4);
            return bl;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    @MustBeLocked(value=ELockType.WRITE)
    private void _initialAdd(@Nonnull Locale locale) {
        this.m_aLocales.put(locale.toString(), locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reinitialize() {
        this.m_aRWLock.writeLock().lock();
        try {
            this.m_aLocales.clear();
            this._initialAdd(CGlobal.LOCALE_ALL);
            this._initialAdd(CGlobal.LOCALE_INDEPENDENT);
            for (Locale object : Locale.getAvailableLocales()) {
                this._initialAdd(object);
            }
            for (String string : Locale.getISOCountries()) {
                this._initialAdd(new Locale("", string));
            }
            for (String string : Locale.getISOLanguages()) {
                this._initialAdd(new Locale(string, ""));
            }
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("Reinitialized " + LocaleCache.class.getName());
        }
    }

    private static final class SingletonHolder {
        static final LocaleCache s_aInstance = new LocaleCache();

        private SingletonHolder() {
        }
    }
}

