/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.mock;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.callback.IThrowingRunnable;
import com.helger.commons.callback.adapter.AdapterRunnableToThrowingRunnable;
import com.helger.commons.charset.CCharset;
import com.helger.commons.concurrent.ManagedExecutorService;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.file.iterate.FileSystemIterator;
import com.helger.commons.io.stream.NonBlockingBufferedReader;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.io.streamprovider.ByteArrayInputStreamProvider;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.lang.StackTraceHelper;
import com.helger.commons.microdom.IMicroElement;
import com.helger.commons.microdom.convert.MicroTypeConverter;
import com.helger.commons.microdom.serialize.MicroWriter;
import com.helger.commons.string.StringHelper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class CommonsTestHelper {
    private static final Logger s_aLogger = LoggerFactory.getLogger(CommonsTestHelper.class);
    private static final CommonsTestHelper s_aInstance = new CommonsTestHelper();

    private CommonsTestHelper() {
    }

    private static void _assertTrue(@Nonnull String string, boolean bl) {
        if (!bl) {
            throw new IllegalStateException(string);
        }
    }

    private static void _assertFalse(@Nonnull String string, boolean bl) {
        if (bl) {
            throw new IllegalStateException(string);
        }
    }

    private static void _assertNotNull(@Nonnull String string, Object object) {
        if (object == null) {
            throw new IllegalStateException(string);
        }
    }

    private static <T> void _assertEquals(@Nonnull String string, @Nullable T t, @Nullable T t2) {
        if (!EqualsHelper.equals(t, t2)) {
            throw new IllegalStateException(string + "\nOBJ1: " + t + "\nOBJ2: " + t2);
        }
    }

    @SuppressFBWarnings(value={"EC_NULL_ARG"})
    private static <DATATYPE> void _testEqualsImplementation(@Nonnull DATATYPE DATATYPE) {
        CommonsTestHelper._assertNotNull("Passed object may not be null!", DATATYPE);
        CommonsTestHelper._assertTrue("Passed objects are not equal", DATATYPE.equals(DATATYPE));
        CommonsTestHelper._assertFalse("Object may no be equal to String", DATATYPE.equals("any string"));
        CommonsTestHelper._assertFalse("Object may no be equal to null", DATATYPE.equals(null));
    }

    private static <DATATYPE> void _testEqualsImplementationWithEqualContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        CommonsTestHelper._testEqualsImplementation(DATATYPE);
        CommonsTestHelper._testEqualsImplementation(DATATYPE2);
        CommonsTestHelper._assertFalse("This test may not be used with the same object!", DATATYPE == DATATYPE2);
        CommonsTestHelper._assertTrue("Passed objects are not identical!\n#1: " + DATATYPE + "\n#2: " + DATATYPE2, DATATYPE.equals(DATATYPE2));
        CommonsTestHelper._assertTrue("Passed objects are not identical!\n#1: " + DATATYPE2 + "\n#2: " + DATATYPE, DATATYPE2.equals(DATATYPE));
    }

    private static <DATATYPE> void _testEqualsImplementationWithDifferentContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        CommonsTestHelper._testEqualsImplementation(DATATYPE);
        CommonsTestHelper._testEqualsImplementation(DATATYPE2);
        CommonsTestHelper._assertFalse("This test may not be used with the same object!", DATATYPE == DATATYPE2);
        CommonsTestHelper._assertFalse("Passed objects are identical!", DATATYPE.equals(DATATYPE2));
        CommonsTestHelper._assertFalse("Passed objects are identical!", DATATYPE2.equals(DATATYPE));
    }

    private static <DATATYPE> void _testHashcodeImplementation(@Nonnull DATATYPE DATATYPE) {
        CommonsTestHelper._assertNotNull("Passed object may not be null!", DATATYPE);
        CommonsTestHelper._assertTrue("hashCode() invocations must be consistent", DATATYPE.hashCode() == DATATYPE.hashCode());
        CommonsTestHelper._assertFalse("hashCode() may not be 0", DATATYPE.hashCode() == 0);
    }

    private static <DATATYPE> void _testHashcodeImplementationWithEqualContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        CommonsTestHelper._testHashcodeImplementation(DATATYPE);
        CommonsTestHelper._testHashcodeImplementation(DATATYPE2);
        CommonsTestHelper._assertTrue("Passed objects are not identical!", DATATYPE.equals(DATATYPE2));
        CommonsTestHelper._assertFalse("This test may not be used with the same object!", DATATYPE == DATATYPE2);
        CommonsTestHelper._assertTrue("hashCode() invocations must be consistent", DATATYPE.hashCode() == DATATYPE2.hashCode());
        CommonsTestHelper._assertTrue("hashCode() invocations must be consistent", DATATYPE2.hashCode() == DATATYPE.hashCode());
    }

    private static <DATATYPE> void _testHashcodeImplementationWithDifferentContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        CommonsTestHelper._testHashcodeImplementation(DATATYPE);
        CommonsTestHelper._testHashcodeImplementation(DATATYPE2);
        CommonsTestHelper._assertFalse("Passed objects are identical!", DATATYPE.equals(DATATYPE2));
        CommonsTestHelper._assertFalse("This test may not be used with the same object!", DATATYPE == DATATYPE2);
        int n = DATATYPE.hashCode();
        int n2 = DATATYPE2.hashCode();
        CommonsTestHelper._assertFalse("hashCode() may not be the same for both objects", n == n2);
    }

    public static void testToStringImplementation(@Nonnull Object object) {
        CommonsTestHelper._assertNotNull("Passed object may not be null!", object);
        CommonsTestHelper._assertNotNull("toString() may not return null!", object.toString());
        CommonsTestHelper._assertTrue("toString() may not return an empty string!", object.toString().length() > 0);
        CommonsTestHelper._assertTrue("toString() invocations must be consistent", object.toString().equals(object.toString()));
    }

    private static <DATATYPE> void _testToStringImplementationWithEqualContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        CommonsTestHelper.testToStringImplementation(DATATYPE);
        CommonsTestHelper.testToStringImplementation(DATATYPE2);
        CommonsTestHelper._assertTrue("Passed objects are not identical!", DATATYPE.equals(DATATYPE2));
        CommonsTestHelper._assertFalse("This test may not be used with the same object!", DATATYPE == DATATYPE2);
    }

    private static <DATATYPE> void _testToStringImplementationWithDifferentContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        CommonsTestHelper.testToStringImplementation(DATATYPE);
        CommonsTestHelper.testToStringImplementation(DATATYPE2);
        CommonsTestHelper._assertFalse("Passed objects are identical!", DATATYPE.equals(DATATYPE2));
        CommonsTestHelper._assertFalse("This test may not be used with the same object!", DATATYPE == DATATYPE2);
    }

    public static <DATATYPE> void testDefaultImplementationWithEqualContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        CommonsTestHelper._testEqualsImplementationWithEqualContentObject(DATATYPE, DATATYPE2);
        CommonsTestHelper._testHashcodeImplementationWithEqualContentObject(DATATYPE, DATATYPE2);
        CommonsTestHelper._testToStringImplementationWithEqualContentObject(DATATYPE, DATATYPE2);
    }

    public static <DATATYPE> void testDefaultImplementationWithDifferentContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        CommonsTestHelper._testEqualsImplementationWithDifferentContentObject(DATATYPE, DATATYPE2);
        CommonsTestHelper._testHashcodeImplementationWithDifferentContentObject(DATATYPE, DATATYPE2);
        CommonsTestHelper._testToStringImplementationWithDifferentContentObject(DATATYPE, DATATYPE2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static <DATATYPE extends Serializable> DATATYPE testDefaultSerialization(@Nonnull DATATYPE DATATYPE) {
        try {
            Serializable serializable;
            NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(nonBlockingByteArrayOutputStream);
            try {
                objectOutputStream.writeObject(DATATYPE);
            }
            finally {
                StreamHelper.close(objectOutputStream);
            }
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStreamProvider(nonBlockingByteArrayOutputStream.toByteArray()).getInputStream());
            try {
                serializable = (Serializable)GenericReflection.uncheckedCast(objectInputStream.readObject());
            }
            finally {
                StreamHelper.close(objectInputStream);
            }
            CommonsTestHelper.testDefaultImplementationWithEqualContentObject(DATATYPE, serializable);
            return (DATATYPE)serializable;
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("testDefaultSerialization failed", throwable);
        }
    }

    public static void testGetClone(@Nonnull ICloneable<?> iCloneable) {
        Object obj = iCloneable.getClone();
        CommonsTestHelper._assertNotNull("Clone returned a null object", obj);
        CommonsTestHelper._assertTrue("Clone returned a different class than the original one", obj.getClass().equals(iCloneable.getClass()));
        CommonsTestHelper.testDefaultImplementationWithEqualContentObject(iCloneable, obj);
    }

    public static <T> T testMicroTypeConversion(@Nonnull T t) {
        Assert.assertNotNull(t);
        IMicroElement iMicroElement = MicroTypeConverter.convertToMicroElement(t, "test");
        Assert.assertNotNull((Object)iMicroElement);
        Object obj = MicroTypeConverter.convertToNative(iMicroElement, t.getClass());
        Assert.assertNotNull(obj);
        IMicroElement iMicroElement2 = MicroTypeConverter.convertToMicroElement(obj, "test");
        Assert.assertNotNull((Object)iMicroElement2);
        String string = MicroWriter.getXMLString(iMicroElement);
        String string2 = MicroWriter.getXMLString(iMicroElement2);
        CommonsTestHelper._assertEquals("XML representation must be identical", string, string2);
        CommonsTestHelper.testDefaultImplementationWithEqualContentObject(t, obj);
        return (T)GenericReflection.uncheckedCast(obj);
    }

    public static void testInParallel(@Nonnegative int n, @Nonnull Runnable runnable) {
        ValueEnforcer.notNull(runnable, "Runnable");
        CommonsTestHelper.testInParallel(n, new AdapterRunnableToThrowingRunnable(runnable));
    }

    public static void testInParallel(@Nonnegative int n, final @Nonnull IThrowingRunnable iThrowingRunnable) {
        ValueEnforcer.isGE0(n, "Calls");
        ValueEnforcer.notNull(iThrowingRunnable, "Runnable");
        ExecutorService executorService = Executors.newFixedThreadPool(20);
        final ArrayList arrayList = new ArrayList();
        for (int i = 0; i < n; ++i) {
            executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        iThrowingRunnable.run();
                    }
                    catch (Throwable throwable) {
                        arrayList.add(throwable.getMessage() + "\n" + StackTraceHelper.getStackAsString(throwable));
                    }
                }
            });
        }
        ManagedExecutorService.shutdownAndWaitUntilAllTasksAreFinished(executorService);
        if (!arrayList.isEmpty()) {
            throw new IllegalStateException(StringHelper.getImploded(arrayList));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnegative
    public static int testIfAllSPIFilesAreValid(@Nonnull String string, boolean bl) throws Exception {
        int n = 0;
        File file = new File(string);
        if (file.exists() && file.isDirectory()) {
            for (File file2 : new FileSystemIterator(string)) {
                block11: {
                    if (!file2.isFile()) continue;
                    s_aLogger.info("Checking SPI file " + file2.getAbsolutePath());
                    try {
                        Class.forName(file2.getName());
                    }
                    catch (Throwable throwable) {
                        String string2 = "No interface representing " + file2.getName() + " exists: " + ClassHelper.getClassLocalName(throwable) + " - " + throwable.getMessage();
                        s_aLogger.warn(string2);
                        if (bl) break block11;
                        throw new Exception(string2);
                    }
                }
                NonBlockingBufferedReader nonBlockingBufferedReader = new NonBlockingBufferedReader(StreamHelper.createReader(FileHelper.getInputStream(file2), CCharset.CHARSET_SERVICE_LOADER_OBJ));
                try {
                    String string3;
                    int n2 = 0;
                    while ((string3 = nonBlockingBufferedReader.readLine()) != null) {
                        String string4 = StringHelper.trim(string3);
                        if (!StringHelper.hasText(string4)) continue;
                        Class.forName(string3);
                        ++n2;
                        ++n;
                    }
                    if (n2 == 0) {
                        s_aLogger.warn("  Contains no single valid implementation!");
                        continue;
                    }
                    s_aLogger.info("  All implementations (" + n2 + ") are valid!");
                }
                catch (Throwable throwable) {
                    s_aLogger.warn("  Error checking content: " + throwable.getMessage());
                    if (bl) continue;
                    throw new Exception("Error checking SPI file " + file2.getAbsolutePath(), throwable);
                }
                finally {
                    StreamHelper.close(nonBlockingBufferedReader);
                }
            }
        }
        return n;
    }

    @Nonnegative
    public static int testIfAllSPIImplementationsAreValid() throws Exception {
        return CommonsTestHelper.testIfAllSPIImplementationsAreValid(false);
    }

    @Nonnegative
    public static int testIfAllSPIImplementationsAreValid(boolean bl) throws Exception {
        int n = 0;
        n += CommonsTestHelper.testIfAllSPIFilesAreValid("src/main/resources/META-INF/services", bl);
        return n += CommonsTestHelper.testIfAllSPIFilesAreValid("src/test/resources/META-INF/services", bl);
    }
}

