/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.scope;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.scope.AbstractMapBasedScope;
import com.helger.commons.scope.IApplicationScope;
import com.helger.commons.scope.IGlobalScope;
import com.helger.commons.scope.ScopeHelper;
import com.helger.commons.scope.mgr.MetaScopeFactory;
import com.helger.commons.scope.spi.ScopeSPIManager;
import com.helger.commons.string.ToStringGenerator;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class GlobalScope
extends AbstractMapBasedScope
implements IGlobalScope {
    private static final Logger s_aLogger = LoggerFactory.getLogger(GlobalScope.class);
    private final Map<String, IApplicationScope> m_aAppScopes = new HashMap<String, IApplicationScope>();

    public GlobalScope(@Nonnull @Nonempty String string) {
        super(string);
        if (ScopeHelper.debugGlobalScopeLifeCycle(s_aLogger)) {
            s_aLogger.info("Created global scope '" + this.getID() + "' of class " + ClassHelper.getClassLocalName(this), ScopeHelper.getDebugStackTrace());
        }
    }

    @Override
    public void initScope() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void destroyOwnedScopes() {
        this.m_aRWLock.writeLock().lock();
        try {
            for (IApplicationScope iApplicationScope : this.m_aAppScopes.values()) {
                ScopeSPIManager.getInstance().onApplicationScopeEnd(iApplicationScope);
                iApplicationScope.destroyScope();
            }
            this.m_aAppScopes.clear();
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    @Override
    protected void preDestroy() {
        if (ScopeHelper.debugGlobalScopeLifeCycle(s_aLogger)) {
            s_aLogger.info("Destroying global scope '" + this.getID() + "' of class " + ClassHelper.getClassLocalName(this), ScopeHelper.getDebugStackTrace());
        }
    }

    @Override
    protected void postDestroy() {
        if (ScopeHelper.debugGlobalScopeLifeCycle(s_aLogger)) {
            s_aLogger.info("Destroyed global scope '" + this.getID() + "' of class " + ClassHelper.getClassLocalName(this), ScopeHelper.getDebugStackTrace());
        }
    }

    @Nonnull
    @OverrideOnDemand
    protected IApplicationScope createApplicationScope(@Nonnull @Nonempty String string) {
        return MetaScopeFactory.getScopeFactory().createApplicationScope(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public IApplicationScope getApplicationScope(@Nonnull @Nonempty String string, boolean bl) {
        IApplicationScope iApplicationScope;
        ValueEnforcer.notEmpty(string, "ApplicationID");
        this.m_aRWLock.readLock().lock();
        try {
            iApplicationScope = this.m_aAppScopes.get(string);
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
        if (iApplicationScope == null && bl) {
            this.m_aRWLock.writeLock().lock();
            try {
                iApplicationScope = this.m_aAppScopes.get(string);
                if (iApplicationScope == null) {
                    iApplicationScope = this.createApplicationScope(string);
                    this.m_aAppScopes.put(string, iApplicationScope);
                    iApplicationScope.initScope();
                    ScopeSPIManager.getInstance().onApplicationScopeBegin(iApplicationScope);
                }
            }
            finally {
                this.m_aRWLock.writeLock().unlock();
            }
        }
        return iApplicationScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Map<String, IApplicationScope> getAllApplicationScopes() {
        this.m_aRWLock.readLock().lock();
        try {
            Map<String, IApplicationScope> map = CollectionHelper.newMap(this.m_aAppScopes);
            return map;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnegative
    public int getApplicationScopeCount() {
        this.m_aRWLock.readLock().lock();
        try {
            int n = this.m_aAppScopes.size();
            return n;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        GlobalScope globalScope = (GlobalScope)object;
        return this.m_aAppScopes.equals(globalScope.m_aAppScopes);
    }

    @Override
    public int hashCode() {
        return ((HashCodeGenerator)HashCodeGenerator.getDerived(super.hashCode()).append((Map)this.m_aAppScopes)).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("appScopes", this.m_aAppScopes).toString();
    }
}

