/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.serialize.convert;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.lang.ClassHierarchyCache;
import com.helger.commons.lang.ServiceLoaderHelper;
import com.helger.commons.serialize.convert.ISerializationConverter;
import com.helger.commons.serialize.convert.ISerializationConverterCallback;
import com.helger.commons.serialize.convert.ISerializationConverterRegistrarSPI;
import com.helger.commons.serialize.convert.ISerializationConverterRegistry;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class SerializationConverterRegistry
implements ISerializationConverterRegistry {
    private static final Logger s_aLogger = LoggerFactory.getLogger(SerializationConverterRegistry.class);
    private static boolean s_bDefaultInstantiated = false;
    private final ReadWriteLock m_aRWLock = new ReentrantReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final Map<Class<?>, ISerializationConverter> m_aMap = new WeakHashMap();

    private SerializationConverterRegistry() {
        this.reinitialize();
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static SerializationConverterRegistry getInstance() {
        SerializationConverterRegistry serializationConverterRegistry = SingletonHolder.s_aInstance;
        s_bDefaultInstantiated = true;
        return serializationConverterRegistry;
    }

    @Override
    public void registerSerializationConverter(@Nonnull Class<?> clazz, @Nonnull ISerializationConverter iSerializationConverter) {
        this._registerSerializationConverter(clazz, iSerializationConverter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _registerSerializationConverter(@Nonnull Class<?> clazz, @Nonnull ISerializationConverter iSerializationConverter) {
        ValueEnforcer.notNull(clazz, "Class");
        ValueEnforcer.notNull(iSerializationConverter, "Converter");
        if (Serializable.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("The provided " + clazz.toString() + " is already Serializable!");
        }
        this.m_aRWLock.writeLock().lock();
        try {
            if (this.m_aMap.containsKey(clazz)) {
                throw new IllegalArgumentException("A micro type converter for class " + clazz + " is already registered!");
            }
            for (WeakReference<Class<?>> weakReference : ClassHierarchyCache.getClassHierarchyIterator(clazz)) {
                Class clazz2 = (Class)weakReference.get();
                if (clazz2 == null || this.m_aMap.containsKey(clazz2)) continue;
                this.m_aMap.put(clazz2, iSerializationConverter);
                if (!s_aLogger.isDebugEnabled()) continue;
                s_aLogger.debug("Registered serialization converter for '" + clazz2.toString() + "'");
            }
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ISerializationConverter getConverter(@Nullable Class<?> clazz) {
        this.m_aRWLock.readLock().lock();
        try {
            ISerializationConverter iSerializationConverter = this.m_aMap.get(clazz);
            if (iSerializationConverter == null) {
                for (WeakReference weakReference : ClassHierarchyCache.getClassHierarchyIterator(clazz)) {
                    Class clazz2 = (Class)weakReference.get();
                    if (clazz2 == null || (iSerializationConverter = this.m_aMap.get(clazz2)) == null) continue;
                    if (!s_aLogger.isDebugEnabled()) break;
                    s_aLogger.debug("Using serialization converter " + iSerializationConverter + " for class " + clazz + " based on " + clazz2);
                    break;
                }
            }
            ISerializationConverter iSerializationConverter2 = iSerializationConverter;
            return iSerializationConverter2;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iterateAllRegisteredSerializationConverters(@Nonnull ISerializationConverterCallback iSerializationConverterCallback) {
        Map<Class<?>, ISerializationConverter> map;
        this.m_aRWLock.readLock().lock();
        try {
            map = CollectionHelper.newMap(this.m_aMap);
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
        for (Map.Entry<Class<?>, ISerializationConverter> entry : map.entrySet()) {
            if (iSerializationConverterCallback.call(entry.getKey(), entry.getValue()).isBreak()) break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnegative
    public int getRegisteredSerializationConverterCount() {
        this.m_aRWLock.readLock().lock();
        try {
            int n = this.m_aMap.size();
            return n;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reinitialize() {
        this.m_aRWLock.writeLock().lock();
        try {
            this.m_aMap.clear();
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        for (ISerializationConverterRegistrarSPI iSerializationConverterRegistrarSPI : ServiceLoaderHelper.getAllSPIImplementations(ISerializationConverterRegistrarSPI.class)) {
            iSerializationConverterRegistrarSPI.registerSerializationConverter(this);
        }
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug(this.getRegisteredSerializationConverterCount() + " serialization converters registered");
        }
    }

    private static final class SingletonHolder {
        static final SerializationConverterRegistry s_aInstance = new SerializationConverterRegistry();

        private SingletonHolder() {
        }
    }
}

