/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.attr;

import com.helger.commons.collection.attr.IAttributeContainer;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.string.StringParser;
import com.helger.commons.typeconvert.TypeConverter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class AbstractReadOnlyAttributeContainer<KEYTYPE, VALUETYPE>
implements IAttributeContainer<KEYTYPE, VALUETYPE> {
    private static final Logger s_aLogger = LoggerFactory.getLogger(AbstractReadOnlyAttributeContainer.class);

    @Override
    @Nullable
    public final <DATATYPE> DATATYPE getCastedAttribute(@Nullable KEYTYPE KEYTYPE) {
        return (DATATYPE)GenericReflection.uncheckedCast(this.getAttributeObject(KEYTYPE));
    }

    @Override
    @Nullable
    public final <DATATYPE> DATATYPE getCastedAttribute(@Nullable KEYTYPE KEYTYPE, @Nullable DATATYPE DATATYPE) {
        DATATYPE DATATYPE2 = this.getCastedAttribute(KEYTYPE);
        return DATATYPE2 == null ? DATATYPE : DATATYPE2;
    }

    @Override
    @Nullable
    public final <DATATYPE> DATATYPE getTypedAttribute(@Nullable KEYTYPE KEYTYPE, @Nonnull Class<DATATYPE> clazz) {
        return TypeConverter.convertIfNecessary(this.getAttributeObject(KEYTYPE), clazz);
    }

    @Override
    @Nullable
    public final <DATATYPE> DATATYPE getTypedAttribute(@Nullable KEYTYPE KEYTYPE, @Nonnull Class<DATATYPE> clazz, @Nullable DATATYPE DATATYPE) {
        DATATYPE DATATYPE2 = this.getTypedAttribute(KEYTYPE, clazz);
        return DATATYPE2 == null ? DATATYPE : DATATYPE2;
    }

    @Override
    @Nullable
    public final String getAttributeAsString(@Nullable KEYTYPE KEYTYPE) {
        return this.getAttributeAsString(KEYTYPE, null);
    }

    @Nullable
    public static String getAsString(@Nullable Object object, @Nullable Object object2, @Nullable String string) {
        if (object2 == null) {
            return string;
        }
        if (object2 instanceof String) {
            return (String)object2;
        }
        if (object2 instanceof String[]) {
            Object[] objectArray = (String[])object2;
            s_aLogger.warn("The parameter '" + String.valueOf(object) + "' is an array with " + objectArray.length + " items; using the first one if possible: " + Arrays.toString(objectArray));
            return objectArray.length > 0 ? objectArray[0] : string;
        }
        return object2.toString();
    }

    @Override
    @Nullable
    public final String getAttributeAsString(@Nullable KEYTYPE KEYTYPE, @Nullable String string) {
        Object VALUETYPE = this.getAttributeObject(KEYTYPE);
        return AbstractReadOnlyAttributeContainer.getAsString(KEYTYPE, VALUETYPE, string);
    }

    public static int getAsInt(@Nullable Object object, @Nullable Object object2, int n) {
        if (object2 == null) {
            return n;
        }
        if (object2 instanceof Number) {
            return ((Number)object2).intValue();
        }
        String string = AbstractReadOnlyAttributeContainer.getAsString(object, object2, null);
        return StringParser.parseInt(string, n);
    }

    @Override
    public final int getAttributeAsInt(@Nullable KEYTYPE KEYTYPE) {
        return this.getAttributeAsInt(KEYTYPE, -1);
    }

    @Override
    public final int getAttributeAsInt(@Nullable KEYTYPE KEYTYPE, int n) {
        Object VALUETYPE = this.getAttributeObject(KEYTYPE);
        return AbstractReadOnlyAttributeContainer.getAsInt(KEYTYPE, VALUETYPE, n);
    }

    public static long getAsLong(@Nullable Object object, @Nullable Object object2, long l) {
        if (object2 == null) {
            return l;
        }
        if (object2 instanceof Number) {
            return ((Number)object2).longValue();
        }
        String string = AbstractReadOnlyAttributeContainer.getAsString(object, object2, null);
        return StringParser.parseLong(string, l);
    }

    @Override
    public final long getAttributeAsLong(@Nullable KEYTYPE KEYTYPE) {
        return this.getAttributeAsLong(KEYTYPE, -1L);
    }

    @Override
    public final long getAttributeAsLong(@Nullable KEYTYPE KEYTYPE, long l) {
        Object VALUETYPE = this.getAttributeObject(KEYTYPE);
        return AbstractReadOnlyAttributeContainer.getAsLong(KEYTYPE, VALUETYPE, l);
    }

    public static double getAsDouble(@Nullable Object object, @Nullable Object object2, double d) {
        if (object2 == null) {
            return d;
        }
        if (object2 instanceof Number) {
            return ((Number)object2).doubleValue();
        }
        String string = AbstractReadOnlyAttributeContainer.getAsString(object, object2, null);
        return StringParser.parseDouble(string, d);
    }

    @Override
    public final double getAttributeAsDouble(@Nullable KEYTYPE KEYTYPE) {
        return this.getAttributeAsDouble(KEYTYPE, -1.0);
    }

    @Override
    public final double getAttributeAsDouble(@Nullable KEYTYPE KEYTYPE, double d) {
        Object VALUETYPE = this.getAttributeObject(KEYTYPE);
        return AbstractReadOnlyAttributeContainer.getAsDouble(KEYTYPE, VALUETYPE, d);
    }

    public static boolean getAsBoolean(@Nullable Object object, @Nullable Object object2, boolean bl) {
        if (object2 == null) {
            return bl;
        }
        if (object2 instanceof Boolean) {
            return (Boolean)object2;
        }
        String string = AbstractReadOnlyAttributeContainer.getAsString(object, object2, null);
        return StringParser.parseBool(string, bl);
    }

    @Override
    public final boolean getAttributeAsBoolean(@Nullable KEYTYPE KEYTYPE) {
        return this.getAttributeAsBoolean(KEYTYPE, false);
    }

    @Override
    public final boolean getAttributeAsBoolean(@Nullable KEYTYPE KEYTYPE, boolean bl) {
        Object VALUETYPE = this.getAttributeObject(KEYTYPE);
        return AbstractReadOnlyAttributeContainer.getAsBoolean(KEYTYPE, VALUETYPE, bl);
    }

    @Nullable
    public static BigInteger getAsBigInteger(@Nullable Object object, @Nullable Object object2, @Nullable BigInteger bigInteger) {
        if (object2 == null) {
            return bigInteger;
        }
        if (object2 instanceof Number) {
            return BigInteger.valueOf(((Number)object2).longValue());
        }
        String string = AbstractReadOnlyAttributeContainer.getAsString(object, object2, null);
        return StringParser.parseBigInteger(string, bigInteger);
    }

    @Override
    @Nullable
    public final BigInteger getAttributeAsBigInteger(@Nullable KEYTYPE KEYTYPE) {
        return this.getAttributeAsBigInteger(KEYTYPE, null);
    }

    @Override
    @Nullable
    public final BigInteger getAttributeAsBigInteger(@Nullable KEYTYPE KEYTYPE, @Nullable BigInteger bigInteger) {
        Object VALUETYPE = this.getAttributeObject(KEYTYPE);
        return AbstractReadOnlyAttributeContainer.getAsBigInteger(KEYTYPE, VALUETYPE, bigInteger);
    }

    @Nullable
    public static BigDecimal getAsBigDecimal(@Nullable Object object, @Nullable Object object2, @Nullable BigDecimal bigDecimal) {
        if (object2 == null) {
            return bigDecimal;
        }
        if (object2 instanceof Number) {
            return BigDecimal.valueOf(((Number)object2).longValue());
        }
        String string = AbstractReadOnlyAttributeContainer.getAsString(object, object2, null);
        return StringParser.parseBigDecimal(string, bigDecimal);
    }

    @Override
    @Nullable
    public final BigDecimal getAttributeAsBigDecimal(@Nullable KEYTYPE KEYTYPE) {
        return this.getAttributeAsBigDecimal(KEYTYPE, null);
    }

    @Override
    @Nullable
    public final BigDecimal getAttributeAsBigDecimal(@Nullable KEYTYPE KEYTYPE, @Nullable BigDecimal bigDecimal) {
        Object VALUETYPE = this.getAttributeObject(KEYTYPE);
        return AbstractReadOnlyAttributeContainer.getAsBigDecimal(KEYTYPE, VALUETYPE, bigDecimal);
    }
}

