/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.iterate;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ArrayIterator<ELEMENTTYPE>
implements Iterator<ELEMENTTYPE> {
    private final ELEMENTTYPE[] m_aArray;
    private int m_nIndex;

    public ArrayIterator(ELEMENTTYPE ... ELEMENTTYPEArray) {
        ValueEnforcer.notNull(ELEMENTTYPEArray, "Array");
        this.m_nIndex = 0;
        this.m_aArray = ArrayHelper.getCopy(ELEMENTTYPEArray);
    }

    private ArrayIterator(@Nonnull ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isArrayOfsLen(ELEMENTTYPEArray, n, n2);
        this.m_nIndex = 0;
        this.m_aArray = ArrayHelper.getCopy(ELEMENTTYPEArray, n, n2);
    }

    @Override
    public boolean hasNext() {
        return this.m_nIndex < this.m_aArray.length;
    }

    @Override
    @Nullable
    public ELEMENTTYPE next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.m_aArray[this.m_nIndex++];
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ArrayIterator arrayIterator = (ArrayIterator)object;
        return EqualsHelper.equals(this.m_aArray, arrayIterator.m_aArray) && this.m_nIndex == arrayIterator.m_nIndex;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aArray).append(this.m_nIndex).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("array", Arrays.toString(this.m_aArray)).append("index", this.m_nIndex).toString();
    }

    @Nonnull
    public static <ELEMENTTYPE> ArrayIterator<ELEMENTTYPE> create(@Nonnull ELEMENTTYPE[] ELEMENTTYPEArray) {
        return new ArrayIterator<ELEMENTTYPE>(ELEMENTTYPEArray);
    }

    @Nonnull
    public static <ELEMENTTYPE> ArrayIterator<ELEMENTTYPE> createOfsLen(@Nonnull ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnegative int n, @Nonnegative int n2) {
        return new ArrayIterator<ELEMENTTYPE>(ELEMENTTYPEArray, n, n2);
    }
}

