/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.microdom.convert;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.lang.ClassHierarchyCache;
import com.helger.commons.lang.ServiceLoaderHelper;
import com.helger.commons.microdom.convert.IMicroTypeConverter;
import com.helger.commons.microdom.convert.IMicroTypeConverterCallback;
import com.helger.commons.microdom.convert.IMicroTypeConverterRegistrarSPI;
import com.helger.commons.microdom.convert.IMicroTypeConverterRegistry;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class MicroTypeConverterRegistry
implements IMicroTypeConverterRegistry {
    private static final Logger s_aLogger = LoggerFactory.getLogger(MicroTypeConverterRegistry.class);
    private static boolean s_bDefaultInstantiated = false;
    private final ReadWriteLock m_aRWLock = new ReentrantReadWriteLock();
    private final Map<Class<?>, IMicroTypeConverter> m_aMap = new WeakHashMap();

    private MicroTypeConverterRegistry() {
        this.reinitialize();
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static MicroTypeConverterRegistry getInstance() {
        MicroTypeConverterRegistry microTypeConverterRegistry = SingletonHolder.s_aInstance;
        s_bDefaultInstantiated = true;
        return microTypeConverterRegistry;
    }

    @Override
    public void registerMicroElementTypeConverter(@Nonnull Class<?> clazz, @Nonnull IMicroTypeConverter iMicroTypeConverter) {
        this._registerMicroElementTypeConverter(clazz, iMicroTypeConverter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _registerMicroElementTypeConverter(@Nonnull Class<?> clazz, @Nonnull IMicroTypeConverter iMicroTypeConverter) {
        ValueEnforcer.notNull(clazz, "Class");
        ValueEnforcer.notNull(iMicroTypeConverter, "Converter");
        this.m_aRWLock.writeLock().lock();
        try {
            if (this.m_aMap.containsKey(clazz)) {
                throw new IllegalArgumentException("A micro type converter for class " + clazz + " is already registered!");
            }
            for (WeakReference<Class<?>> weakReference : ClassHierarchyCache.getClassHierarchyIterator(clazz)) {
                Class clazz2 = (Class)weakReference.get();
                if (clazz2 == null || this.m_aMap.containsKey(clazz2)) continue;
                this.m_aMap.put(clazz2, iMicroTypeConverter);
                if (!s_aLogger.isDebugEnabled()) continue;
                s_aLogger.debug("Registered micro type converter for '" + clazz2.toString() + "'");
            }
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IMicroTypeConverter getConverterToMicroElement(@Nullable Class<?> clazz) {
        this.m_aRWLock.readLock().lock();
        try {
            IMicroTypeConverter iMicroTypeConverter = this.m_aMap.get(clazz);
            return iMicroTypeConverter;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IMicroTypeConverter getConverterToNative(@Nonnull Class<?> clazz) {
        ValueEnforcer.notNull(clazz, "DestClass");
        this.m_aRWLock.readLock().lock();
        try {
            IMicroTypeConverter iMicroTypeConverter = this.m_aMap.get(clazz);
            if (iMicroTypeConverter == null) {
                for (WeakReference weakReference : ClassHierarchyCache.getClassHierarchyIterator(clazz)) {
                    Class clazz2 = (Class)weakReference.get();
                    if (clazz2 == null || (iMicroTypeConverter = this.m_aMap.get(clazz2)) == null) continue;
                    if (!s_aLogger.isDebugEnabled()) break;
                    s_aLogger.debug("Using micro type converter " + iMicroTypeConverter + " for class " + clazz + " based on " + clazz2);
                    break;
                }
            }
            IMicroTypeConverter iMicroTypeConverter2 = iMicroTypeConverter;
            return iMicroTypeConverter2;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iterateAllRegisteredMicroTypeConverters(@Nonnull IMicroTypeConverterCallback iMicroTypeConverterCallback) {
        Map<Class<?>, IMicroTypeConverter> map;
        this.m_aRWLock.readLock().lock();
        try {
            map = CollectionHelper.newMap(this.m_aMap);
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
        for (Map.Entry<Class<?>, IMicroTypeConverter> entry : map.entrySet()) {
            if (iMicroTypeConverterCallback.call(entry.getKey(), entry.getValue()).isBreak()) break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnegative
    public int getRegisteredMicroTypeConverterCount() {
        this.m_aRWLock.readLock().lock();
        try {
            int n = this.m_aMap.size();
            return n;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reinitialize() {
        this.m_aRWLock.writeLock().lock();
        try {
            this.m_aMap.clear();
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        for (IMicroTypeConverterRegistrarSPI iMicroTypeConverterRegistrarSPI : ServiceLoaderHelper.getAllSPIImplementations(IMicroTypeConverterRegistrarSPI.class)) {
            iMicroTypeConverterRegistrarSPI.registerMicroTypeConverter(this);
        }
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug(this.getRegisteredMicroTypeConverterCount() + " micro type converters registered");
        }
    }

    private static final class SingletonHolder {
        static final MicroTypeConverterRegistry s_aInstance = new MicroTypeConverterRegistry();

        private SingletonHolder() {
        }
    }
}

