/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.charset;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsImmutableObject;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.string.StringHelper;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.SortedMap;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CharsetManager {
    private static final SortedMap<String, Charset> s_aAllCharsets = Charset.availableCharsets();
    private static final CharsetManager s_aInstance = new CharsetManager();

    private CharsetManager() {
    }

    @Nonnull
    public static Charset getCharsetFromName(@Nonnull @Nonempty String string) {
        try {
            return Charset.forName(string);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            throw new IllegalArgumentException("Charset '" + string + "' unsupported in Java", illegalCharsetNameException);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            throw new IllegalArgumentException("Charset '" + string + "' unsupported on this platform", unsupportedCharsetException);
        }
    }

    @Nullable
    public static Charset getCharsetFromNameOrNull(@Nullable String string) {
        if (StringHelper.hasText(string)) {
            try {
                return CharsetManager.getCharsetFromName(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nonnull
    @ReturnsImmutableObject
    public static SortedMap<String, Charset> getAllCharsets() {
        return s_aAllCharsets;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static byte[] getAsBytes(@Nonnull String string, @Nonnull Charset charset) {
        ValueEnforcer.notNull(string, "Text");
        ValueEnforcer.notNull(charset, "Charset");
        if (!charset.canEncode()) {
            throw new IllegalArgumentException("Cannot encode to " + charset);
        }
        return string.getBytes(charset);
    }

    @Nullable
    public static String getAsStringInOtherCharset(@Nullable String string, @Nonnull Charset charset, @Nonnull Charset charset2) {
        ValueEnforcer.notNull(charset, "CurrentCharset");
        ValueEnforcer.notNull(charset2, "NewCharset");
        if (string == null || charset.equals(charset2)) {
            return string;
        }
        return CharsetManager.getAsString(CharsetManager.getAsBytes(string, charset), charset2);
    }

    @Nonnull
    public static String getAsString(@Nonnull byte[] byArray, @Nonnull Charset charset) {
        ValueEnforcer.notNull(byArray, "Buffer");
        return CharsetManager.getAsString(byArray, 0, byArray.length, charset);
    }

    @Nonnull
    public static String getAsString(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull Charset charset) {
        ValueEnforcer.isArrayOfsLen(byArray, n, n2);
        ValueEnforcer.notNull(charset, "Charset");
        return new String(byArray, n, n2, charset);
    }

    @Nonnegative
    public static int getUTF8ByteCount(@Nullable String string) {
        return string == null ? 0 : CharsetManager.getUTF8ByteCount(string.toCharArray());
    }

    @Nonnegative
    public static int getUTF8ByteCount(@Nullable char[] cArray) {
        int n = 0;
        if (cArray != null) {
            for (char c : cArray) {
                n += CharsetManager.getUTF8ByteCount(c);
            }
        }
        return n;
    }

    @Nonnegative
    public static int getUTF8ByteCount(char c) {
        return CharsetManager.getUTF8ByteCount((int)c);
    }

    @Nonnegative
    public static int getUTF8ByteCount(@Nonnegative int n) {
        ValueEnforcer.isBetweenInclusive(n, "c", 0, 65535);
        if (n == 0) {
            return 2;
        }
        if (n <= 127) {
            return 1;
        }
        if (n <= 2047) {
            return 2;
        }
        if (n <= 55295) {
            return 3;
        }
        return 0;
    }
}

