/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.file.filter;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.io.file.filter.AbstractFileFilter;
import com.helger.commons.string.ToStringGenerator;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class FileFilterFilenameEndsWith
extends AbstractFileFilter {
    private final String m_sSuffix;

    public FileFilterFilenameEndsWith(@Nonnull @Nonempty String string) {
        this.m_sSuffix = ValueEnforcer.notEmpty(string, "Suffix");
    }

    @Nonnull
    @Nonempty
    public String getSuffix() {
        return this.m_sSuffix;
    }

    @Override
    public boolean matchesThisFilter(@Nullable File file) {
        String string;
        if (file != null && (string = FilenameHelper.getSecureFilename(file.getName())) != null) {
            return string.endsWith(this.m_sSuffix);
        }
        return false;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        FileFilterFilenameEndsWith fileFilterFilenameEndsWith = (FileFilterFilenameEndsWith)object;
        return this.m_sSuffix.equals(fileFilterFilenameEndsWith.m_sSuffix);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_sSuffix).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("suffix", this.m_sSuffix).toString();
    }
}

