/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.socket;

import com.helger.commons.exception.mock.IMockException;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.state.ESuccess;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class SocketHelper {
    private static final Logger s_aLogger = LoggerFactory.getLogger(SocketHelper.class);
    private static final SocketHelper s_aInstance = new SocketHelper();

    private SocketHelper() {
    }

    @Nonnull
    public static ESuccess close(@Nullable @WillClose Socket socket) {
        block3: {
            if (socket != null && !socket.isClosed()) {
                try {
                    socket.close();
                    return ESuccess.SUCCESS;
                }
                catch (IOException iOException) {
                    if (StreamHelper.isKnownEOFException(iOException)) break block3;
                    s_aLogger.error("Failed to close socket " + socket.getClass().getName(), (Throwable)(iOException instanceof IMockException ? null : iOException));
                }
            }
        }
        return ESuccess.FAILURE;
    }

    @Nonnull
    public static ESuccess close(@Nullable @WillClose ServerSocket serverSocket) {
        block3: {
            if (serverSocket != null && !serverSocket.isClosed()) {
                try {
                    serverSocket.close();
                    return ESuccess.SUCCESS;
                }
                catch (IOException iOException) {
                    if (StreamHelper.isKnownEOFException(iOException)) break block3;
                    s_aLogger.error("Failed to close server socket " + serverSocket.getClass().getName(), (Throwable)(iOException instanceof IMockException ? null : iOException));
                }
            }
        }
        return ESuccess.FAILURE;
    }
}

