/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.microdom;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.microdom.AbstractMicroNode;
import com.helger.commons.microdom.EMicroNodeType;
import com.helger.commons.microdom.IMicroNode;
import com.helger.commons.microdom.IMicroProcessingInstruction;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class MicroProcessingInstruction
extends AbstractMicroNode
implements IMicroProcessingInstruction {
    private final String m_sTarget;
    private final String m_sData;

    public MicroProcessingInstruction(@Nonnull @Nonempty String string) {
        this(string, null);
    }

    public MicroProcessingInstruction(@Nonnull @Nonempty String string, @Nullable String string2) {
        this.m_sTarget = ValueEnforcer.notEmpty(string, "Target");
        this.m_sData = string2;
    }

    @Override
    @Nonnull
    public EMicroNodeType getType() {
        return EMicroNodeType.PROCESSING_INSTRUCTION;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getNodeName() {
        return "#pi";
    }

    @Override
    @Nonnull
    @Nonempty
    public String getNodeValue() {
        return this.m_sTarget;
    }

    @Override
    public String getTarget() {
        return this.m_sTarget;
    }

    @Override
    public String getData() {
        return this.m_sData;
    }

    @Override
    @Nonnull
    public IMicroProcessingInstruction getClone() {
        return new MicroProcessingInstruction(this.m_sTarget, this.m_sData);
    }

    @Override
    public boolean isEqualContent(@Nullable IMicroNode iMicroNode) {
        if (iMicroNode == this) {
            return true;
        }
        if (iMicroNode == null || !this.getClass().equals(iMicroNode.getClass())) {
            return false;
        }
        MicroProcessingInstruction microProcessingInstruction = (MicroProcessingInstruction)iMicroNode;
        return this.m_sTarget.equals(microProcessingInstruction.m_sTarget) && EqualsHelper.equals(this.m_sData, microProcessingInstruction.m_sData);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("target", this.m_sTarget).append("data", this.m_sData).toString();
    }
}

