/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.timing;

import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.state.EChange;
import com.helger.commons.state.IStoppable;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class StopWatch
implements IStoppable,
Serializable {
    private long m_nStartDT = 0L;
    private long m_nDurationNanos = 0L;

    protected StopWatch(boolean bl) {
        if (bl) {
            this.start();
        }
    }

    @Nonnull
    public EChange reset() {
        if (this.m_nDurationNanos == 0L) {
            return EChange.UNCHANGED;
        }
        this.m_nDurationNanos = 0L;
        return EChange.CHANGED;
    }

    @OverrideOnDemand
    protected long getCurrentNanoTime() {
        return System.nanoTime();
    }

    @Nonnull
    public EChange start() {
        if (this.m_nStartDT > 0L) {
            return EChange.UNCHANGED;
        }
        this.m_nStartDT = this.getCurrentNanoTime();
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public EChange stop() {
        if (this.m_nStartDT == 0L) {
            return EChange.UNCHANGED;
        }
        long l = this.getCurrentNanoTime();
        this.m_nDurationNanos += l - this.m_nStartDT;
        this.m_nStartDT = 0L;
        return EChange.CHANGED;
    }

    public void restart() {
        this.stop();
        this.reset();
        this.start();
    }

    public boolean isStarted() {
        return this.m_nStartDT > 0L;
    }

    public boolean isStopped() {
        return this.m_nStartDT == 0L;
    }

    @Nonnegative
    public long getNanos() {
        return this.m_nDurationNanos;
    }

    @Nonnegative
    public long getMillis() {
        return this.m_nDurationNanos / 1000000L;
    }

    @Nonnegative
    public long getSeconds() {
        return this.m_nDurationNanos / 1000000000L;
    }

    @Nonnegative
    public long stopAndGetNanos() {
        this.stop();
        return this.getNanos();
    }

    @Nonnegative
    public long stopAndGetMillis() {
        this.stop();
        return this.getMillis();
    }

    @Nonnegative
    public long stopAndGetSeconds() {
        this.stop();
        return this.getSeconds();
    }

    public String toString() {
        return new ToStringGenerator(this).append("StartDT", this.m_nStartDT).append("DurationNanos", this.m_nDurationNanos).toString();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static StopWatch createdStarted() {
        return new StopWatch(true);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static StopWatch createdStopped() {
        return new StopWatch(false);
    }
}

