/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.messagedigest;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.charset.CharsetManager;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.messagedigest.EMessageDigestAlgorithm;
import com.helger.commons.messagedigest.NonBlockingMessageDigestGenerator;
import com.helger.commons.string.StringHelper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.WillClose;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class MessageDigestGeneratorHelper {
    private static final MessageDigestGeneratorHelper s_aInstance = new MessageDigestGeneratorHelper();

    private MessageDigestGeneratorHelper() {
    }

    public static long getLongFromDigest(@Nonnull byte[] byArray) {
        long l = 0L;
        for (int i = 0; i < byArray.length; i += 2) {
            l += (long)((byte)(byArray[i] << 8) | byArray[i + 1]);
        }
        return l;
    }

    @Nonnull
    public static String getHexValueFromDigest(@Nonnull byte[] byArray) {
        return StringHelper.getHexEncoded(byArray);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static byte[] getAllDigestBytes(@Nonnull EMessageDigestAlgorithm eMessageDigestAlgorithm, @Nonnull String string, @Nonnull Charset charset) {
        return MessageDigestGeneratorHelper.getAllDigestBytes(string, charset, eMessageDigestAlgorithm);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static byte[] getAllDigestBytes(@Nonnull EMessageDigestAlgorithm eMessageDigestAlgorithm, @Nonnull byte[] byArray) {
        return MessageDigestGeneratorHelper.getAllDigestBytes(byArray, eMessageDigestAlgorithm);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static byte[] getAllDigestBytes(@Nonnull EMessageDigestAlgorithm eMessageDigestAlgorithm, @Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        return MessageDigestGeneratorHelper.getAllDigestBytes(byArray, n, n2, eMessageDigestAlgorithm);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static byte[] getAllDigestBytes(@Nonnull String string, @Nonnull Charset charset, EMessageDigestAlgorithm ... eMessageDigestAlgorithmArray) {
        return MessageDigestGeneratorHelper.getAllDigestBytes(CharsetManager.getAsBytes(string, charset), eMessageDigestAlgorithmArray);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static byte[] getAllDigestBytes(@Nonnull byte[] byArray, EMessageDigestAlgorithm ... eMessageDigestAlgorithmArray) {
        return MessageDigestGeneratorHelper.getAllDigestBytes(byArray, new NonBlockingMessageDigestGenerator(eMessageDigestAlgorithmArray));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static byte[] getAllDigestBytes(@Nonnull byte[] byArray, @Nonnull NonBlockingMessageDigestGenerator nonBlockingMessageDigestGenerator) {
        return nonBlockingMessageDigestGenerator.update(byArray).getAllDigestBytes();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static byte[] getAllDigestBytes(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2, EMessageDigestAlgorithm ... eMessageDigestAlgorithmArray) {
        return MessageDigestGeneratorHelper.getAllDigestBytes(byArray, n, n2, new NonBlockingMessageDigestGenerator(eMessageDigestAlgorithmArray));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static byte[] getAllDigestBytes(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull NonBlockingMessageDigestGenerator nonBlockingMessageDigestGenerator) {
        return nonBlockingMessageDigestGenerator.update(byArray, n, n2).getAllDigestBytes();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static byte[] getAllDigestBytesFromInputStream(@Nonnull @WillClose InputStream inputStream, EMessageDigestAlgorithm ... eMessageDigestAlgorithmArray) {
        ValueEnforcer.notNull(inputStream, "InputStream");
        NonBlockingMessageDigestGenerator nonBlockingMessageDigestGenerator = new NonBlockingMessageDigestGenerator(eMessageDigestAlgorithmArray);
        return MessageDigestGeneratorHelper.getAllDigestBytesFromInputStream(inputStream, nonBlockingMessageDigestGenerator);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static byte[] getAllDigestBytesFromInputStream(@Nonnull @WillClose InputStream inputStream, @Nonnull NonBlockingMessageDigestGenerator nonBlockingMessageDigestGenerator) {
        ValueEnforcer.notNull(inputStream, "InputStream");
        ValueEnforcer.notNull(nonBlockingMessageDigestGenerator, "MDGen");
        byte[] byArray = new byte[2048];
        try {
            int n;
            while ((n = inputStream.read(byArray)) > -1) {
                nonBlockingMessageDigestGenerator.update(byArray, 0, n);
            }
            byte[] byArray2 = nonBlockingMessageDigestGenerator.getAllDigestBytes();
            return byArray2;
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Failed to read from InputStream for digesting!", iOException);
        }
        finally {
            StreamHelper.close(inputStream);
        }
    }
}

