/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.scope.util;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.callback.INonThrowingRunnable;
import com.helger.commons.scope.mgr.ScopeManager;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;

public abstract class AbstractScopeAwareRunnable
implements INonThrowingRunnable {
    private final String m_sApplicationID;
    private final String m_sRequestID;
    private final String m_sSessionID;

    public AbstractScopeAwareRunnable() {
        this(ScopeManager.getApplicationScope().getID());
    }

    public AbstractScopeAwareRunnable(@Nonnull @Nonempty String string) {
        this(string, "mock.request", "mock.session");
    }

    public AbstractScopeAwareRunnable(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull @Nonempty String string3) {
        this.m_sApplicationID = ValueEnforcer.notEmpty(string, "ApplicationID");
        this.m_sRequestID = ValueEnforcer.notEmpty(string2, "RequestID");
        this.m_sSessionID = ValueEnforcer.notEmpty(string3, "SessionID");
    }

    @Nonnull
    @Nonempty
    public String getApplicationID() {
        return this.m_sApplicationID;
    }

    @Nonnull
    @Nonempty
    public String getRequestID() {
        return this.m_sRequestID;
    }

    @Nonnull
    @Nonempty
    public String getSessionID() {
        return this.m_sSessionID;
    }

    protected abstract void scopedRun();

    @Override
    public final void run() {
        ScopeManager.onRequestBegin(this.m_sApplicationID, this.m_sRequestID, this.m_sSessionID);
        try {
            this.scopedRun();
        }
        finally {
            ScopeManager.onRequestEnd();
        }
    }

    public String toString() {
        return new ToStringGenerator(this).append("applicationID", this.m_sApplicationID).append("requestID", this.m_sRequestID).append("sessionID", this.m_sSessionID).toString();
    }
}

