/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.xml.sax;

import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import com.helger.commons.io.stream.StreamHelper;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.NotThreadSafe;
import org.xml.sax.InputSource;

@NotThreadSafe
public class CachingSAXInputSource
extends InputSource {
    @Nonnull
    private static NonBlockingByteArrayInputStream _getCachedInputStream(@Nonnull @WillClose InputStream inputStream) {
        return new NonBlockingByteArrayInputStream(StreamHelper.getAllBytes(inputStream));
    }

    public CachingSAXInputSource(@Nonnull IReadableResource iReadableResource) {
        this(iReadableResource.getInputStream(), iReadableResource.getResourceID());
    }

    public CachingSAXInputSource(@Nonnull IHasInputStream iHasInputStream) {
        this(iHasInputStream.getInputStream(), null);
    }

    public CachingSAXInputSource(@Nonnull IHasInputStream iHasInputStream, @Nullable String string) {
        this(iHasInputStream.getInputStream(), string);
    }

    public CachingSAXInputSource(@Nonnull @WillClose InputStream inputStream) {
        this(inputStream, null);
    }

    public CachingSAXInputSource(@Nonnull @WillClose InputStream inputStream, @Nullable String string) {
        super(CachingSAXInputSource._getCachedInputStream(inputStream));
        this.setSystemId(string);
    }
}

