/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.changelog;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.changelog.AbstractChangeLogEntry;
import com.helger.commons.changelog.ChangeLog;
import com.helger.commons.changelog.ChangeLogEntry;
import com.helger.commons.changelog.ChangeLogRelease;
import com.helger.commons.changelog.EChangeLogAction;
import com.helger.commons.changelog.EChangeLogCategory;
import com.helger.commons.changelog.IChangeLogSerializerCallback;
import com.helger.commons.changelog.LoggingChangeLogSerializerCallback;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.resource.URLResource;
import com.helger.commons.lang.ClassLoaderHelper;
import com.helger.commons.microdom.IMicroDocument;
import com.helger.commons.microdom.IMicroElement;
import com.helger.commons.microdom.MicroDocument;
import com.helger.commons.microdom.convert.MicroTypeConverter;
import com.helger.commons.microdom.serialize.MicroReader;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.StringParser;
import com.helger.commons.text.MultilingualText;
import com.helger.commons.version.Version;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class ChangeLogSerializer {
    private static final Logger s_aLogger = LoggerFactory.getLogger(ChangeLogSerializer.class);
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String ELEMENT_CHANGELOG = "changelog";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_COMPONENT = "component";
    private static final String ELEMENT_ENTRY = "entry";
    private static final String ATTR_DATE = "date";
    private static final String ATTR_ACTION = "action";
    private static final String ATTR_CATEGORY = "category";
    private static final String ATTR_INCOMPATIBLE = "incompatible";
    private static final String ELEMENT_CHANGE = "change";
    private static final String ELEMENT_ISSUE = "issue";
    private static final String ELEMENT_RELEASE = "release";
    private static final IChangeLogSerializerCallback s_aDefaultCallback = new LoggingChangeLogSerializerCallback();
    private static final ChangeLogSerializer s_aInstance = new ChangeLogSerializer();

    private ChangeLogSerializer() {
    }

    @Nullable
    public static ChangeLog readChangeLog(@Nullable IHasInputStream iHasInputStream) {
        return ChangeLogSerializer.readChangeLog(iHasInputStream, s_aDefaultCallback);
    }

    @Nullable
    public static ChangeLog readChangeLog(@Nullable IHasInputStream iHasInputStream, @Nonnull IChangeLogSerializerCallback iChangeLogSerializerCallback) {
        ValueEnforcer.notNull(iChangeLogSerializerCallback, "ErrorCallback");
        IMicroDocument iMicroDocument = MicroReader.readMicroXML(iHasInputStream);
        if (iMicroDocument == null) {
            return null;
        }
        IMicroElement iMicroElement = iMicroDocument.getDocumentElement();
        if (iMicroElement == null) {
            return null;
        }
        ChangeLog changeLog = new ChangeLog(iMicroElement.getAttributeValue(ATTR_VERSION), iMicroElement.getAttributeValue(ATTR_COMPONENT));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT);
        for (IMicroElement iMicroElement2 : iMicroElement.getAllChildElements()) {
            Object object;
            String string;
            String string2;
            if (!"http://www.helger.com/xsd/changelog/1.0".equals(iMicroElement2.getNamespaceURI())) {
                iChangeLogSerializerCallback.run("Element '" + iMicroElement2.getTagName() + "' has the wrong namespace URI '" + iMicroElement2.getNamespaceURI() + "'");
                continue;
            }
            String string3 = iMicroElement2.getTagName();
            if (ELEMENT_ENTRY.equals(string3)) {
                Date date;
                string2 = iMicroElement2.getAttributeValue(ATTR_DATE);
                string = iMicroElement2.getAttributeValue(ATTR_ACTION);
                object = iMicroElement2.getAttributeValue(ATTR_CATEGORY);
                String string4 = iMicroElement2.getAttributeValue(ATTR_INCOMPATIBLE);
                try {
                    date = simpleDateFormat.parse(string2);
                }
                catch (ParseException parseException) {
                    iChangeLogSerializerCallback.run("Failed to parse entry date '" + string2 + "'");
                    continue;
                }
                EChangeLogAction eChangeLogAction = EChangeLogAction.getFromIDOrNull(string);
                if (eChangeLogAction == null) {
                    iChangeLogSerializerCallback.run("Failed to parse change log action '" + string + "'");
                    continue;
                }
                EChangeLogCategory eChangeLogCategory = EChangeLogCategory.getFromIDOrNull((String)object);
                if (eChangeLogCategory == null) {
                    iChangeLogSerializerCallback.run("Failed to parse change log category '" + (String)object + "'");
                    continue;
                }
                boolean bl = StringHelper.hasText(string4) && StringParser.parseBool(string4);
                ChangeLogEntry changeLogEntry = new ChangeLogEntry(changeLog, date, eChangeLogAction, eChangeLogCategory, bl);
                changeLog.addEntry(changeLogEntry);
                IMicroElement iMicroElement3 = iMicroElement2.getFirstChildElement("http://www.helger.com/xsd/changelog/1.0", ELEMENT_CHANGE);
                if (iMicroElement3 == null) {
                    iChangeLogSerializerCallback.run("No change element present!");
                    continue;
                }
                MultilingualText multilingualText = MicroTypeConverter.convertToNative(iMicroElement3, MultilingualText.class);
                if (multilingualText == null) {
                    iChangeLogSerializerCallback.run("Failed to read multi lingual text in change element!");
                    continue;
                }
                changeLogEntry.setText(multilingualText);
                for (IMicroElement iMicroElement4 : iMicroElement2.getAllChildElements("http://www.helger.com/xsd/changelog/1.0", ELEMENT_ISSUE)) {
                    changeLogEntry.addIssue(iMicroElement4.getTextContent());
                }
                continue;
            }
            if (ELEMENT_RELEASE.equals(string3)) {
                string2 = iMicroElement2.getAttributeValue(ATTR_DATE);
                string = iMicroElement2.getAttributeValue(ATTR_VERSION);
                try {
                    object = simpleDateFormat.parse(string2);
                }
                catch (ParseException parseException) {
                    s_aLogger.warn("Failed to parse release date '" + string2 + "'");
                    continue;
                }
                changeLog.addRelease(new ChangeLogRelease((Date)object, new Version(string, false)));
                continue;
            }
            iChangeLogSerializerCallback.run("Changelog contains unsupported element '" + string3 + "!");
        }
        return changeLog;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Map<URI, ChangeLog> readAllChangeLogs() {
        return ChangeLogSerializer.readAllChangeLogs(s_aDefaultCallback);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Map<URI, ChangeLog> readAllChangeLogs(@Nonnull ClassLoader classLoader) {
        return ChangeLogSerializer.readAllChangeLogs(s_aDefaultCallback, classLoader);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Map<URI, ChangeLog> readAllChangeLogs(@Nonnull IChangeLogSerializerCallback iChangeLogSerializerCallback) {
        return ChangeLogSerializer.readAllChangeLogs(iChangeLogSerializerCallback, ClassLoaderHelper.getDefaultClassLoader());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Map<URI, ChangeLog> readAllChangeLogs(@Nonnull IChangeLogSerializerCallback iChangeLogSerializerCallback, @Nonnull ClassLoader classLoader) {
        ValueEnforcer.notNull(iChangeLogSerializerCallback, "ErrorCallback");
        ValueEnforcer.notNull(classLoader, "ClassLoader");
        try {
            HashMap<URI, ChangeLog> hashMap = new HashMap<URI, ChangeLog>();
            for (URL uRL : CollectionHelper.newList(ClassLoaderHelper.getResources(classLoader, "changelog.xml"))) {
                URLResource uRLResource = new URLResource(uRL);
                ChangeLog changeLog = ChangeLogSerializer.readChangeLog(uRLResource, iChangeLogSerializerCallback);
                if (changeLog != null) {
                    hashMap.put(uRLResource.getAsURI(), changeLog);
                    continue;
                }
                s_aLogger.warn("Failed to read changelog from URL " + uRL.toExternalForm());
            }
            return hashMap;
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Failed to resolved changelogs", iOException);
        }
    }

    @Nonnull
    public static IMicroDocument writeChangeLog(@Nonnull ChangeLog changeLog) {
        ValueEnforcer.notNull(changeLog, "ChangeLog");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT);
        MicroDocument microDocument = new MicroDocument();
        IMicroElement iMicroElement = microDocument.appendElement("http://www.helger.com/xsd/changelog/1.0", ELEMENT_CHANGELOG);
        iMicroElement.setAttribute("http://www.w3.org/2000/xmlns/", "xsi", "http://www.w3.org/2001/XMLSchema-instance");
        iMicroElement.setAttribute("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", "http://www.helger.com/xsd/changelog/1.0 schemas/changelog-1.0.xsd");
        iMicroElement.setAttribute(ATTR_VERSION, changeLog.getOriginalVersion());
        if (StringHelper.hasText(changeLog.getComponent())) {
            iMicroElement.setAttribute(ATTR_COMPONENT, changeLog.getComponent());
        }
        for (AbstractChangeLogEntry abstractChangeLogEntry : changeLog.getAllBaseEntries()) {
            IMicroElement iMicroElement2;
            AbstractChangeLogEntry abstractChangeLogEntry2;
            if (abstractChangeLogEntry instanceof ChangeLogEntry) {
                abstractChangeLogEntry2 = (ChangeLogEntry)abstractChangeLogEntry;
                iMicroElement2 = iMicroElement.appendElement("http://www.helger.com/xsd/changelog/1.0", ELEMENT_ENTRY);
                iMicroElement2.setAttribute(ATTR_DATE, simpleDateFormat.format(abstractChangeLogEntry2.getDate()));
                iMicroElement2.setAttribute(ATTR_ACTION, ((ChangeLogEntry)abstractChangeLogEntry2).getAction().getID());
                iMicroElement2.setAttribute(ATTR_CATEGORY, ((ChangeLogEntry)abstractChangeLogEntry2).getCategory().getID());
                if (((ChangeLogEntry)abstractChangeLogEntry2).isIncompatible()) {
                    iMicroElement2.setAttribute(ATTR_INCOMPATIBLE, Boolean.TRUE.toString());
                }
                iMicroElement2.appendChild(MicroTypeConverter.convertToMicroElement(((ChangeLogEntry)abstractChangeLogEntry2).getAllTexts(), "http://www.helger.com/xsd/changelog/1.0", ELEMENT_CHANGE));
                for (String string : ((ChangeLogEntry)abstractChangeLogEntry2).getAllIssues()) {
                    iMicroElement2.appendElement("http://www.helger.com/xsd/changelog/1.0", ELEMENT_ISSUE).appendText(string);
                }
                continue;
            }
            abstractChangeLogEntry2 = (ChangeLogRelease)abstractChangeLogEntry;
            iMicroElement2 = iMicroElement.appendElement("http://www.helger.com/xsd/changelog/1.0", ELEMENT_RELEASE);
            iMicroElement2.setAttribute(ATTR_DATE, simpleDateFormat.format(abstractChangeLogEntry2.getDate()));
            iMicroElement2.setAttribute(ATTR_VERSION, ((ChangeLogRelease)abstractChangeLogEntry2).getVersion().getAsString());
        }
        return microDocument;
    }
}

