/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.attr;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.attr.AbstractReadOnlyAttributeContainer;
import com.helger.commons.collection.attr.IAttributeContainer;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class MapBasedReadOnlyAttributeContainer<KEYTYPE, VALUETYPE>
extends AbstractReadOnlyAttributeContainer<KEYTYPE, VALUETYPE> {
    protected final Map<KEYTYPE, VALUETYPE> m_aAttrs;

    public MapBasedReadOnlyAttributeContainer(@Nonnull KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE) {
        this(true, new HashMap());
        this.m_aAttrs.put(KEYTYPE, VALUETYPE);
    }

    public MapBasedReadOnlyAttributeContainer(@Nonnull Map<? extends KEYTYPE, ? extends VALUETYPE> map) {
        this(true, new HashMap<KEYTYPE, VALUETYPE>(map));
    }

    public MapBasedReadOnlyAttributeContainer(@Nonnull IAttributeContainer<? extends KEYTYPE, ? extends VALUETYPE> iAttributeContainer) {
        this(true, new HashMap<KEYTYPE, VALUETYPE>(iAttributeContainer.getAllAttributes()));
    }

    protected MapBasedReadOnlyAttributeContainer(boolean bl, @Nonnull Map<KEYTYPE, VALUETYPE> map) {
        this.m_aAttrs = ValueEnforcer.notNull(map, "AttrMap");
    }

    @Override
    @Nonnull
    public Iterator<Map.Entry<KEYTYPE, VALUETYPE>> iterator() {
        return this.m_aAttrs.entrySet().iterator();
    }

    @Override
    public boolean containsAttribute(@Nullable KEYTYPE KEYTYPE) {
        return KEYTYPE != null && this.m_aAttrs.containsKey(KEYTYPE);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Map<KEYTYPE, VALUETYPE> getAllAttributes() {
        return CollectionHelper.newMap(this.m_aAttrs);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Set<KEYTYPE> getAllAttributeNames() {
        return CollectionHelper.newSet(this.m_aAttrs.keySet());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Collection<VALUETYPE> getAllAttributeValues() {
        return CollectionHelper.newList(this.m_aAttrs.values());
    }

    @Override
    @Nullable
    public VALUETYPE getAttributeObject(@Nullable KEYTYPE KEYTYPE) {
        return KEYTYPE == null ? null : (VALUETYPE)this.m_aAttrs.get(KEYTYPE);
    }

    @Override
    @Nonnegative
    public int getAttributeCount() {
        return this.m_aAttrs.size();
    }

    @Override
    public boolean containsNoAttribute() {
        return this.m_aAttrs.isEmpty();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MapBasedReadOnlyAttributeContainer mapBasedReadOnlyAttributeContainer = (MapBasedReadOnlyAttributeContainer)object;
        return this.m_aAttrs.equals(mapBasedReadOnlyAttributeContainer.m_aAttrs);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append((Map)this.m_aAttrs)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("attrs", this.m_aAttrs).toString();
    }
}

