/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.mime;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.multimap.IMultiMapListBased;
import com.helger.commons.collection.multimap.MultiTreeMapArrayListBased;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.microdom.IMicroDocument;
import com.helger.commons.microdom.IMicroElement;
import com.helger.commons.microdom.MicroDocument;
import com.helger.commons.microdom.convert.MicroTypeConverter;
import com.helger.commons.microdom.serialize.MicroReader;
import com.helger.commons.mime.ComparatorMimeTypeInfoPrimaryMimeType;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.mime.MimeTypeInfo;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class MimeTypeInfoManager {
    public static final String MIME_TYPE_INFO_XML = "codelists/mime-type-info.xml";
    private static boolean s_bDefaultInstantiated = false;
    private final ReadWriteLock m_aRWLock = new ReentrantReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final List<MimeTypeInfo> m_aList = new ArrayList<MimeTypeInfo>();
    @GuardedBy(value="m_aRWLock")
    private final IMultiMapListBased<IMimeType, MimeTypeInfo> m_aMapMimeType = new MultiTreeMapArrayListBased<IMimeType, MimeTypeInfo>();
    @GuardedBy(value="m_aRWLock")
    private final IMultiMapListBased<String, MimeTypeInfo> m_aMapExt = new MultiTreeMapArrayListBased<String, MimeTypeInfo>();

    public static boolean isDefaultInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static MimeTypeInfoManager getDefaultInstance() {
        MimeTypeInfoManager mimeTypeInfoManager = SingletonHolder.s_aInstance;
        s_bDefaultInstantiated = true;
        return mimeTypeInfoManager;
    }

    @Nonnull
    public MimeTypeInfoManager readDefault() {
        return this.read(new ClassPathResource(MIME_TYPE_INFO_XML));
    }

    @Nonnull
    public MimeTypeInfoManager read(@Nonnull IReadableResource iReadableResource) {
        ValueEnforcer.notNull(iReadableResource, "Resource");
        IMicroDocument iMicroDocument = MicroReader.readMicroXML(iReadableResource);
        if (iMicroDocument == null) {
            throw new IllegalArgumentException("Failed to read MimeTypeInfo resource " + iReadableResource);
        }
        for (IMicroElement iMicroElement : iMicroDocument.getDocumentElement().getAllChildElements()) {
            MimeTypeInfo mimeTypeInfo = MicroTypeConverter.convertToNative(iMicroElement, MimeTypeInfo.class);
            this.registerMimeType(mimeTypeInfo);
        }
        return this;
    }

    @Nonnull
    public EChange clearCache() {
        EChange eChange = EChange.UNCHANGED;
        this.m_aRWLock.writeLock().lock();
        try {
            if (!this.m_aList.isEmpty()) {
                this.m_aList.clear();
                eChange = EChange.CHANGED;
            }
            if (!this.m_aMapExt.isEmpty()) {
                this.m_aMapExt.clear();
                eChange = EChange.CHANGED;
            }
            if (!this.m_aMapMimeType.isEmpty()) {
                this.m_aMapMimeType.clear();
                eChange = EChange.CHANGED;
            }
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        return eChange;
    }

    public void reinitializeToDefault() {
        this.clearCache();
        this.readDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public IMicroDocument getAsDocument() {
        MicroDocument microDocument = new MicroDocument();
        IMicroElement iMicroElement = microDocument.appendElement("mime-type-info");
        this.m_aRWLock.readLock().lock();
        try {
            for (MimeTypeInfo mimeTypeInfo : CollectionHelper.getSorted(this.m_aList, new ComparatorMimeTypeInfoPrimaryMimeType())) {
                iMicroElement.appendChild(MicroTypeConverter.convertToMicroElement(mimeTypeInfo, "item"));
            }
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
        return microDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMimeType(@Nonnull MimeTypeInfo mimeTypeInfo) {
        ValueEnforcer.notNull(mimeTypeInfo, "Info");
        Set<MimeTypeInfo.MimeTypeWithSource> set = mimeTypeInfo.getAllMimeTypesWithSource();
        Set<MimeTypeInfo.ExtensionWithSource> set2 = mimeTypeInfo.getAllExtensionsWithSource();
        this.m_aRWLock.readLock().lock();
        try {
            for (MimeTypeInfo.MimeTypeWithSource object : set) {
                List list = (List)this.m_aMapMimeType.get(object.getMimeType());
                if (list == null) continue;
                throw new IllegalArgumentException("Cannot register " + mimeTypeInfo + ". A mapping for mime type '" + object + "' is already registered: " + list);
            }
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
        this.m_aRWLock.writeLock().lock();
        try {
            this.m_aList.add(mimeTypeInfo);
            for (MimeTypeInfo.MimeTypeWithSource mimeTypeWithSource : set) {
                this.m_aMapMimeType.putSingle(mimeTypeWithSource.getMimeType(), mimeTypeInfo);
            }
            for (MimeTypeInfo.ExtensionWithSource extensionWithSource : set2) {
                this.m_aMapExt.putSingle(extensionWithSource.getExtension(), mimeTypeInfo);
            }
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    public final void addExtension(@Nonnull MimeTypeInfo mimeTypeInfo, @Nonnull MimeTypeInfo.ExtensionWithSource extensionWithSource) {
        ValueEnforcer.notNull(mimeTypeInfo, "Info");
        ValueEnforcer.notNull(extensionWithSource, "Ext");
        this.m_aRWLock.writeLock().lock();
        try {
            this.m_aMapExt.putSingle(extensionWithSource.getExtension(), mimeTypeInfo);
            mimeTypeInfo.addExtension(extensionWithSource);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    public final void addMimeType(@Nonnull MimeTypeInfo mimeTypeInfo, @Nonnull MimeTypeInfo.MimeTypeWithSource mimeTypeWithSource) {
        ValueEnforcer.notNull(mimeTypeInfo, "Info");
        ValueEnforcer.notNull(mimeTypeWithSource, "MimeType");
        this.m_aRWLock.writeLock().lock();
        try {
            this.m_aMapMimeType.putSingle(mimeTypeWithSource.getMimeType(), mimeTypeInfo);
            mimeTypeInfo.addMimeType(mimeTypeWithSource);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    @Nullable
    @ReturnsMutableCopy
    public List<MimeTypeInfo> getAllInfosOfFilename(@Nullable File file) {
        if (file == null) {
            return null;
        }
        String string = FilenameHelper.getExtension(file);
        return this.getAllInfosOfExtension(string);
    }

    @Nullable
    @ReturnsMutableCopy
    public List<MimeTypeInfo> getAllInfosOfFilename(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        String string2 = FilenameHelper.getExtension(string);
        return this.getAllInfosOfExtension(string2);
    }

    @Nullable
    @ReturnsMutableCopy
    public List<MimeTypeInfo> getAllInfosOfExtension(@Nullable String string) {
        List list;
        if (string == null) {
            return null;
        }
        this.m_aRWLock.readLock().lock();
        try {
            list = (List)this.m_aMapExt.get(string);
            if (list == null) {
                list = (List)this.m_aMapExt.get(string.toLowerCase(Locale.US));
            }
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
        return list == null ? null : CollectionHelper.newList(list);
    }

    @Nullable
    @ReturnsMutableCopy
    public List<MimeTypeInfo> getAllInfosOfMimeType(@Nullable IMimeType iMimeType) {
        List list;
        if (iMimeType == null) {
            return null;
        }
        this.m_aRWLock.readLock().lock();
        try {
            list = (List)this.m_aMapMimeType.get(iMimeType);
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
        return list == null ? null : CollectionHelper.newList(list);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<MimeTypeInfo> getAllMimeTypeInfos() {
        this.m_aRWLock.readLock().lock();
        try {
            List<MimeTypeInfo> list = CollectionHelper.newList(this.m_aList);
            return list;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public Set<IMimeType> getAllMimeTypes() {
        LinkedHashSet<IMimeType> linkedHashSet = new LinkedHashSet<IMimeType>();
        this.m_aRWLock.readLock().lock();
        try {
            for (MimeTypeInfo mimeTypeInfo : this.m_aList) {
                linkedHashSet.addAll(mimeTypeInfo.getAllMimeTypes());
            }
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
        return linkedHashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public Set<String> getAllMimeTypeStrings() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        this.m_aRWLock.readLock().lock();
        try {
            for (MimeTypeInfo mimeTypeInfo : this.m_aList) {
                linkedHashSet.addAll(mimeTypeInfo.getAllMimeTypeStrings());
            }
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
        return linkedHashSet;
    }

    public boolean containsMimeTypeForFilename(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Filename");
        String string2 = FilenameHelper.getExtension(string);
        return this.containsMimeTypeForExtension(string2);
    }

    @Nonnull
    @ReturnsMutableCopy
    public Set<IMimeType> getAllMimeTypesForFilename(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Filename");
        String string2 = FilenameHelper.getExtension(string);
        return this.getAllMimeTypesForExtension(string2);
    }

    @Nonnull
    @ReturnsMutableCopy
    public Set<String> getAllMimeTypeStringsForFilename(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Filename");
        String string2 = FilenameHelper.getExtension(string);
        return this.getAllMimeTypeStringsForExtension(string2);
    }

    @Nullable
    public IMimeType getPrimaryMimeTypeForFilename(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Filename");
        String string2 = FilenameHelper.getExtension(string);
        return this.getPrimaryMimeTypeForExtension(string2);
    }

    @Nullable
    public String getPrimaryMimeTypeStringForFilename(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Filename");
        String string2 = FilenameHelper.getExtension(string);
        return this.getPrimaryMimeTypeStringForExtension(string2);
    }

    public boolean containsMimeTypeForExtension(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Extension");
        List<MimeTypeInfo> list = this.getAllInfosOfExtension(string);
        return CollectionHelper.isNotEmpty(list);
    }

    @Nonnull
    @ReturnsMutableCopy
    public Set<IMimeType> getAllMimeTypesForExtension(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Extension");
        LinkedHashSet<IMimeType> linkedHashSet = new LinkedHashSet<IMimeType>();
        List<MimeTypeInfo> list = this.getAllInfosOfExtension(string);
        if (list != null) {
            for (MimeTypeInfo mimeTypeInfo : list) {
                linkedHashSet.addAll(mimeTypeInfo.getAllMimeTypes());
            }
        }
        return linkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public Set<String> getAllMimeTypeStringsForExtension(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Extension");
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        List<MimeTypeInfo> list = this.getAllInfosOfExtension(string);
        if (list != null) {
            for (MimeTypeInfo mimeTypeInfo : list) {
                linkedHashSet.addAll(mimeTypeInfo.getAllMimeTypeStrings());
            }
        }
        return linkedHashSet;
    }

    @Nullable
    public IMimeType getPrimaryMimeTypeForExtension(@Nonnull String string) {
        Iterator<MimeTypeInfo> iterator;
        ValueEnforcer.notNull(string, "Extension");
        List<MimeTypeInfo> list = this.getAllInfosOfExtension(string);
        if (list != null && (iterator = list.iterator()).hasNext()) {
            MimeTypeInfo mimeTypeInfo = iterator.next();
            return mimeTypeInfo.getPrimaryMimeType();
        }
        return null;
    }

    @Nullable
    public String getPrimaryMimeTypeStringForExtension(@Nonnull String string) {
        Iterator<MimeTypeInfo> iterator;
        ValueEnforcer.notNull(string, "Extension");
        List<MimeTypeInfo> list = this.getAllInfosOfExtension(string);
        if (list != null && (iterator = list.iterator()).hasNext()) {
            MimeTypeInfo mimeTypeInfo = iterator.next();
            return mimeTypeInfo.getPrimaryMimeTypeString();
        }
        return null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public Set<String> getAllExtensionsOfMimeType(@Nullable IMimeType iMimeType) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        List<MimeTypeInfo> list = this.getAllInfosOfMimeType(iMimeType);
        if (list != null) {
            for (MimeTypeInfo mimeTypeInfo : list) {
                linkedHashSet.addAll(mimeTypeInfo.getAllExtensions());
            }
        }
        return linkedHashSet;
    }

    @Nullable
    public String getPrimaryExtensionOfMimeType(@Nullable IMimeType iMimeType) {
        List<MimeTypeInfo> list = this.getAllInfosOfMimeType(iMimeType);
        if (list != null) {
            for (MimeTypeInfo mimeTypeInfo : list) {
                String string = mimeTypeInfo.getPrimaryExtension();
                if (string == null) continue;
                return string;
            }
        }
        return null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public Set<String> getAllGlobsOfMimeType(@Nullable IMimeType iMimeType) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        List<MimeTypeInfo> list = this.getAllInfosOfMimeType(iMimeType);
        if (list != null) {
            for (MimeTypeInfo mimeTypeInfo : list) {
                linkedHashSet.addAll(mimeTypeInfo.getAllGlobs());
            }
        }
        return linkedHashSet;
    }

    private static final class SingletonHolder {
        static final MimeTypeInfoManager s_aInstance = new MimeTypeInfoManager().readDefault();

        private SingletonHolder() {
        }
    }
}

