/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.scope;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;

@ThreadSafe
public final class ScopeHelper {
    public static final boolean DEFAULT_DEBUG_LIFE_CYCLE = false;
    public static final boolean DEFAULT_DEBUG_GLOBAL_SCOPE = false;
    public static final boolean DEFAULT_DEBUG_APPLICATION_SCOPE = false;
    public static final boolean DEFAULT_DEBUG_SESSION_SCOPE = false;
    public static final boolean DEFAULT_DEBUG_SESSION_APPLICATION_SCOPE = false;
    public static final boolean DEFAULT_DEBUG_REQUEST_SCOPE = false;
    public static final boolean DEFAULT_DEBUG_WITH_STACK_TRACE = false;
    private static final ReadWriteLock s_aRWLock = new ReentrantReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bDebugLifeCycle = false;
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bDebugGlobalScope = false;
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bDebugApplicationScope = false;
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bDebugSessionScope = false;
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bDebugSessionApplicationScope = false;
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bDebugRequestScope = false;
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bDebugWithStackTrace = false;

    private ScopeHelper() {
    }

    public static void setLifeCycleDebuggingEnabled(boolean bl) {
        s_aRWLock.writeLock().lock();
        try {
            s_bDebugLifeCycle = bl;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    public static boolean isLifeCycleDebuggingEnabled() {
        s_aRWLock.readLock().lock();
        try {
            boolean bl = s_bDebugLifeCycle;
            return bl;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    public static void setDebugGlobalScopeEnabled(boolean bl) {
        s_aRWLock.writeLock().lock();
        try {
            s_bDebugGlobalScope = bl;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    public static boolean isDebugGlobalScopeEnabled() {
        s_aRWLock.readLock().lock();
        try {
            boolean bl = s_bDebugGlobalScope;
            return bl;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    public static void setDebugApplicationScopeEnabled(boolean bl) {
        s_aRWLock.writeLock().lock();
        try {
            s_bDebugApplicationScope = bl;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    public static boolean isDebugApplicationScopeEnabled() {
        s_aRWLock.readLock().lock();
        try {
            boolean bl = s_bDebugApplicationScope;
            return bl;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    public static void setDebugSessionScopeEnabled(boolean bl) {
        s_aRWLock.writeLock().lock();
        try {
            s_bDebugSessionScope = bl;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    public static boolean isDebugSessionScopeEnabled() {
        s_aRWLock.readLock().lock();
        try {
            boolean bl = s_bDebugSessionScope;
            return bl;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    public static void setDebugSessionApplicationScopeEnabled(boolean bl) {
        s_aRWLock.writeLock().lock();
        try {
            s_bDebugSessionApplicationScope = bl;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    public static boolean isDebugSessionApplicationScopeEnabled() {
        s_aRWLock.readLock().lock();
        try {
            boolean bl = s_bDebugSessionApplicationScope;
            return bl;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    public static void setDebugRequestScopeEnabled(boolean bl) {
        s_aRWLock.writeLock().lock();
        try {
            s_bDebugRequestScope = bl;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    public static boolean isDebugRequestScopeEnabled() {
        s_aRWLock.readLock().lock();
        try {
            boolean bl = s_bDebugRequestScope;
            return bl;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    public static void setDebugWithStackTrace(boolean bl) {
        s_aRWLock.writeLock().lock();
        try {
            s_bDebugWithStackTrace = bl;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    public static boolean isDebugWithStackTrace() {
        s_aRWLock.readLock().lock();
        try {
            boolean bl = s_bDebugWithStackTrace;
            return bl;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    public static boolean debugGlobalScopeLifeCycle(@Nonnull Logger logger) {
        if (logger.isDebugEnabled()) {
            return true;
        }
        return (ScopeHelper.isLifeCycleDebuggingEnabled() || ScopeHelper.isDebugGlobalScopeEnabled()) && logger.isInfoEnabled();
    }

    public static boolean debugApplicationScopeLifeCycle(@Nonnull Logger logger) {
        if (logger.isDebugEnabled()) {
            return true;
        }
        return (ScopeHelper.isLifeCycleDebuggingEnabled() || ScopeHelper.isDebugApplicationScopeEnabled()) && logger.isInfoEnabled();
    }

    public static boolean debugSessionScopeLifeCycle(@Nonnull Logger logger) {
        if (logger.isDebugEnabled()) {
            return true;
        }
        return (ScopeHelper.isLifeCycleDebuggingEnabled() || ScopeHelper.isDebugSessionScopeEnabled()) && logger.isInfoEnabled();
    }

    public static boolean debugSessionApplicationScopeLifeCycle(@Nonnull Logger logger) {
        if (logger.isDebugEnabled()) {
            return true;
        }
        return (ScopeHelper.isLifeCycleDebuggingEnabled() || ScopeHelper.isDebugSessionApplicationScopeEnabled()) && logger.isInfoEnabled();
    }

    public static boolean debugRequestScopeLifeCycle(@Nonnull Logger logger) {
        if (logger.isDebugEnabled()) {
            return true;
        }
        return (ScopeHelper.isLifeCycleDebuggingEnabled() || ScopeHelper.isDebugRequestScopeEnabled()) && logger.isInfoEnabled();
    }

    @Nullable
    public static Throwable getDebugStackTrace() {
        return ScopeHelper.isDebugWithStackTrace() ? new Exception() : null;
    }
}

